/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.cmmn.impl;

import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.HttpClientConfig;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.FlowableHttpRequestHandler;
import org.flowable.cmmn.model.FlowableHttpResponseHandler;
import org.flowable.cmmn.model.HttpServiceTask;
import org.flowable.cmmn.model.ImplementationType;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.http.ExpressionUtils;
import org.flowable.http.HttpActivityExecutor;
import org.flowable.http.HttpRequest;
import org.flowable.http.NopErrorPropagator;
import org.flowable.http.cmmn.impl.handler.ClassDelegateHttpHandler;
import org.flowable.http.cmmn.impl.handler.DelegateExpressionHttpHandler;
import org.flowable.http.delegate.HttpRequestHandler;
import org.flowable.http.delegate.HttpResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnHttpActivityBehaviorImpl
extends CoreCmmnActivityBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnHttpActivityBehaviorImpl.class);
    protected String requestMethod;
    protected String requestUrl;
    protected String requestHeaders;
    protected String requestBody;
    protected String requestBodyEncoding;
    protected String requestTimeout;
    protected String disallowRedirects;
    protected String failStatusCodes;
    protected String handleStatusCodes;
    protected String ignoreException;
    protected String saveRequestVariables;
    protected String saveResponseParameters;
    protected String responseVariableName;
    protected String saveResponseParametersTransient;
    protected String saveResponseVariableAsJson;
    protected String resultVariablePrefix;
    protected HttpServiceTask serviceTask;
    protected HttpActivityExecutor httpActivityExecutor;

    public CmmnHttpActivityBehaviorImpl() {
        HttpClientConfig config = CommandContextUtil.getCmmnEngineConfiguration().getHttpClientConfig();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (config.isDisableCertVerify()) {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(builder.build(), new HostnameVerifier(){

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                }));
            }
            catch (Exception e) {
                LOGGER.error("Could not configure HTTP client SSL self signed strategy", (Throwable)e);
            }
        }
        int retryCount = 0;
        if (config.getRequestRetryLimit() > 0) {
            retryCount = config.getRequestRetryLimit();
        }
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(retryCount, false));
        if (config.isUseSystemProperties()) {
            httpClientBuilder.useSystemProperties();
        }
        this.httpActivityExecutor = new HttpActivityExecutor(httpClientBuilder, new NopErrorPropagator(), CommandContextUtil.getCmmnEngineConfiguration().getObjectMapper());
    }

    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        HttpRequest request = new HttpRequest();
        try {
            request.setMethod(ExpressionUtils.getStringFromField(this.createExpression(this.requestMethod), (VariableContainer)planItemInstanceEntity));
            request.setUrl(ExpressionUtils.getStringFromField(this.createExpression(this.requestUrl), (VariableContainer)planItemInstanceEntity));
            request.setHeaders(ExpressionUtils.getStringFromField(this.createExpression(this.requestHeaders), (VariableContainer)planItemInstanceEntity));
            request.setBody(ExpressionUtils.getStringFromField(this.createExpression(this.requestBody), (VariableContainer)planItemInstanceEntity));
            request.setBodyEncoding(ExpressionUtils.getStringFromField(this.createExpression(this.requestBodyEncoding), (VariableContainer)planItemInstanceEntity));
            request.setTimeout(ExpressionUtils.getIntFromField(this.createExpression(this.requestTimeout), (VariableContainer)planItemInstanceEntity));
            request.setNoRedirects(ExpressionUtils.getBooleanFromField(this.createExpression(this.disallowRedirects), (VariableContainer)planItemInstanceEntity));
            request.setIgnoreErrors(ExpressionUtils.getBooleanFromField(this.createExpression(this.ignoreException), (VariableContainer)planItemInstanceEntity));
            request.setSaveRequest(ExpressionUtils.getBooleanFromField(this.createExpression(this.saveRequestVariables), (VariableContainer)planItemInstanceEntity));
            request.setSaveResponse(ExpressionUtils.getBooleanFromField(this.createExpression(this.saveResponseParameters), (VariableContainer)planItemInstanceEntity));
            request.setSaveResponseTransient(ExpressionUtils.getBooleanFromField(this.createExpression(this.saveResponseParametersTransient), (VariableContainer)planItemInstanceEntity));
            request.setSaveResponseAsJson(ExpressionUtils.getBooleanFromField(this.createExpression(this.saveResponseVariableAsJson), (VariableContainer)planItemInstanceEntity));
            request.setPrefix(ExpressionUtils.getStringFromField(this.createExpression(this.resultVariablePrefix), (VariableContainer)planItemInstanceEntity));
            String failCodes = ExpressionUtils.getStringFromField(this.createExpression(this.failStatusCodes), (VariableContainer)planItemInstanceEntity);
            String handleCodes = ExpressionUtils.getStringFromField(this.createExpression(this.handleStatusCodes), (VariableContainer)planItemInstanceEntity);
            if (failCodes != null) {
                request.setFailCodes(ExpressionUtils.getStringSetFromField(failCodes));
            }
            if (handleCodes != null) {
                request.setHandleCodes(ExpressionUtils.getStringSetFromField(handleCodes));
            }
            if (request.getPrefix() == null) {
                request.setPrefix(planItemInstanceEntity.getElementId());
            }
            if (request.isSaveRequest()) {
                planItemInstanceEntity.setVariable(request.getPrefix() + "RequestMethod", (Object)request.getMethod());
                planItemInstanceEntity.setVariable(request.getPrefix() + "RequestUrl", (Object)request.getUrl());
                planItemInstanceEntity.setVariable(request.getPrefix() + "RequestHeaders", (Object)request.getHeaders());
                planItemInstanceEntity.setVariable(request.getPrefix() + "RequestBody", (Object)request.getBody());
                planItemInstanceEntity.setVariable(request.getPrefix() + "RequestBodyEncoding", (Object)request.getBodyEncoding());
                planItemInstanceEntity.setVariable(request.getPrefix() + "RequestTimeout", (Object)request.getTimeout());
                planItemInstanceEntity.setVariable(request.getPrefix() + "DisallowRedirects", (Object)request.isNoRedirects());
                planItemInstanceEntity.setVariable(request.getPrefix() + "FailStatusCodes", (Object)failCodes);
                planItemInstanceEntity.setVariable(request.getPrefix() + "HandleStatusCodes", (Object)handleCodes);
                planItemInstanceEntity.setVariable(request.getPrefix() + "IgnoreException", (Object)request.isIgnoreErrors());
                planItemInstanceEntity.setVariable(request.getPrefix() + "SaveRequestVariables", (Object)request.isSaveRequest());
                planItemInstanceEntity.setVariable(request.getPrefix() + "SaveResponseParameters", (Object)request.isSaveResponse());
            }
        }
        catch (Exception e) {
            if (e instanceof FlowableException) {
                throw (FlowableException)e;
            }
            throw new FlowableException("request fields are invalid in execution " + planItemInstanceEntity.getId(), (Throwable)e);
        }
        this.httpActivityExecutor.validate(request);
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration();
        HttpClientConfig httpClientConfig = cmmnEngineConfiguration.getHttpClientConfig();
        this.httpActivityExecutor.execute(request, (VariableContainer)planItemInstanceEntity, planItemInstanceEntity.getId(), this.createHttpRequestHandler(this.serviceTask.getHttpRequestHandler(), cmmnEngineConfiguration), this.createHttpResponseHandler(this.serviceTask.getHttpResponseHandler(), cmmnEngineConfiguration), ExpressionUtils.getStringFromField(this.createExpression(this.responseVariableName), (VariableContainer)planItemInstanceEntity), Collections.emptyList(), httpClientConfig.getSocketTimeout(), httpClientConfig.getConnectTimeout(), httpClientConfig.getConnectionRequestTimeout());
        CommandContextUtil.getAgenda().planCompletePlanItemInstanceOperation(planItemInstanceEntity);
    }

    protected Expression createExpression(String expressionString) {
        if (StringUtils.isEmpty((CharSequence)expressionString)) {
            return null;
        }
        return CommandContextUtil.getCmmnEngineConfiguration().getExpressionManager().createExpression(expressionString);
    }

    protected HttpRequestHandler createHttpRequestHandler(FlowableHttpRequestHandler flowableHandler, CmmnEngineConfiguration cmmnEngineConfiguration) {
        HttpResponseHandler handler = null;
        if (flowableHandler != null) {
            if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(flowableHandler.getImplementationType())) {
                handler = new ClassDelegateHttpHandler(flowableHandler.getImplementation(), (List<FieldExtension>)flowableHandler.getFieldExtensions());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(flowableHandler.getImplementationType())) {
                handler = new DelegateExpressionHttpHandler(cmmnEngineConfiguration.getExpressionManager().createExpression(flowableHandler.getImplementation()), flowableHandler.getFieldExtensions());
            }
        }
        return handler;
    }

    protected HttpResponseHandler createHttpResponseHandler(FlowableHttpResponseHandler handler, CmmnEngineConfiguration cmmnEngineConfiguration) {
        HttpResponseHandler responseHandler = null;
        if (handler != null) {
            if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(handler.getImplementationType())) {
                responseHandler = new ClassDelegateHttpHandler(handler.getImplementation(), (List<FieldExtension>)handler.getFieldExtensions());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(handler.getImplementationType())) {
                responseHandler = new DelegateExpressionHttpHandler(cmmnEngineConfiguration.getExpressionManager().createExpression(handler.getImplementation()), handler.getFieldExtensions());
            }
        }
        return responseHandler;
    }

    public void setServiceTask(HttpServiceTask serviceTask) {
        this.serviceTask = serviceTask;
    }
}

