/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.management.jmx.mbeans;

import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.management.jmx.annotations.ManagedAttribute;
import org.flowable.management.jmx.annotations.ManagedOperation;
import org.flowable.management.jmx.annotations.ManagedResource;

@ManagedResource(description="Job executor MBean")
public class JobExecutorMBean {
    AsyncExecutor jobExecutor;

    public JobExecutorMBean(ProcessEngineConfiguration processEngineConfig) {
        this.jobExecutor = processEngineConfig.getAsyncExecutor();
    }

    @ManagedAttribute(description="check if the job executor is activated")
    public boolean isJobExecutorActivated() {
        return this.jobExecutor != null && this.jobExecutor.isActive();
    }

    @ManagedOperation(description="set job executor activate")
    public void setJobExecutorActivate(Boolean active) {
        if (active.booleanValue()) {
            this.jobExecutor.start();
        } else {
            this.jobExecutor.shutdown();
        }
    }
}

