/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.DataAssociation;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.Process;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class FlowElementValidator
extends ProcessLevelValidator {
    protected static final int ID_MAX_LENGTH = 255;

    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof Activity)) continue;
            Activity activity = (Activity)flowElement;
            this.handleConstraints(process, activity, errors);
            this.handleMultiInstanceLoopCharacteristics(process, activity, errors);
            this.handleDataAssociations(process, activity, errors);
        }
    }

    protected void handleConstraints(Process process, Activity activity, List<ValidationError> errors) {
        if (activity.getId() != null && activity.getId().length() > 255) {
            this.addError(errors, "flowable-flow-element-id-too-long", process, (BaseElement)activity, "The id of a flow element must not contain more than 255 characters");
        }
    }

    protected void handleMultiInstanceLoopCharacteristics(Process process, Activity activity, List<ValidationError> errors) {
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = activity.getLoopCharacteristics();
        if (multiInstanceLoopCharacteristics != null) {
            if (StringUtils.isEmpty((CharSequence)multiInstanceLoopCharacteristics.getLoopCardinality()) && StringUtils.isEmpty((CharSequence)multiInstanceLoopCharacteristics.getInputDataItem()) && StringUtils.isEmpty((CharSequence)multiInstanceLoopCharacteristics.getCollectionString())) {
                this.addError(errors, "flowable-multi-instance-missing-collection", process, (BaseElement)activity, "Either loopCardinality or loopDataInputRef/flowable:collection must been set");
            }
            if (!StringUtils.isEmpty((CharSequence)multiInstanceLoopCharacteristics.getCollectionString()) && multiInstanceLoopCharacteristics.getHandler() == null) {
                this.addError(errors, "flowable-multi-instance-missing-collection-parser", process, (BaseElement)activity, "The flowable:collection element string value requires the function parameters flowable:delegateExpression or flowable:class.");
            }
        }
    }

    protected void handleDataAssociations(Process process, Activity activity, List<ValidationError> errors) {
        if (activity.getDataInputAssociations() != null) {
            for (DataAssociation dataAssociation : activity.getDataInputAssociations()) {
                if (!StringUtils.isEmpty((CharSequence)dataAssociation.getTargetRef())) continue;
                this.addError(errors, "flowable-data-association-missing-targetref", process, (BaseElement)activity, "Targetref is required on a data association");
            }
        }
        if (activity.getDataOutputAssociations() != null) {
            for (DataAssociation dataAssociation : activity.getDataOutputAssociations()) {
                if (!StringUtils.isEmpty((CharSequence)dataAssociation.getTargetRef())) continue;
                this.addError(errors, "flowable-data-association-missing-targetref", process, (BaseElement)activity, "Targetref is required on a data association");
            }
        }
    }
}

