/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.CaseServiceTask;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.ExternalWorkerServiceTask;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.bpmn.model.TaskWithFieldExtensions;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public abstract class ExternalInvocationTaskValidator
extends ProcessLevelValidator {
    protected void validateFieldDeclarationsForEmail(Process process, TaskWithFieldExtensions task, List<FieldExtension> fieldExtensions, List<ValidationError> errors) {
        boolean toDefined = false;
        boolean textOrHtmlDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            if ("to".equals(fieldExtension.getFieldName())) {
                toDefined = true;
            }
            if ("html".equals(fieldExtension.getFieldName())) {
                textOrHtmlDefined = true;
            }
            if ("htmlVar".equals(fieldExtension.getFieldName())) {
                textOrHtmlDefined = true;
            }
            if ("text".equals(fieldExtension.getFieldName())) {
                textOrHtmlDefined = true;
            }
            if (!"textVar".equals(fieldExtension.getFieldName())) continue;
            textOrHtmlDefined = true;
        }
        if (!toDefined) {
            this.addError(errors, "flowable-mailtask-no-recipient", process, (BaseElement)task, "No recipient is defined on the mail activity");
        }
        if (!textOrHtmlDefined) {
            this.addError(errors, "flowable-mailtask-no-content", process, (BaseElement)task, "Text, html, textVar or htmlVar field should be provided");
        }
    }

    protected void validateFieldDeclarationsForShell(Process process, TaskWithFieldExtensions task, List<FieldExtension> fieldExtensions, List<ValidationError> errors) {
        boolean shellCommandDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            String fieldName = fieldExtension.getFieldName();
            String fieldValue = fieldExtension.getStringValue();
            if ("command".equals(fieldName)) {
                shellCommandDefined = true;
            }
            if (!"wait".equals(fieldName) && !"redirectError".equals(fieldName) && !"cleanEnv".equals(fieldName) || "true".equals(fieldValue.toLowerCase()) || "false".equals(fieldValue.toLowerCase())) continue;
            this.addError(errors, "flowable-shelltask-invalid-param", process, (BaseElement)task, "Undefined parameter value for shell field");
        }
        if (!shellCommandDefined) {
            this.addError(errors, "flowable-shelltask-no-command", process, (BaseElement)task, "No shell command is defined on the shell activity");
        }
    }

    protected void validateFieldDeclarationsForDmn(Process process, TaskWithFieldExtensions task, List<FieldExtension> fieldExtensions, List<ValidationError> errors) {
        boolean keyDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            String fieldName = fieldExtension.getFieldName();
            String fieldValue = fieldExtension.getStringValue();
            if ("decisionTableReferenceKey".equals(fieldName) && fieldValue != null && fieldValue.length() > 0) {
                keyDefined = true;
                break;
            }
            if (!"decisionServiceReferenceKey".equals(fieldName) || fieldValue == null || fieldValue.length() <= 0) continue;
            keyDefined = true;
            break;
        }
        if (!keyDefined) {
            this.addError(errors, "flowable-dmntask-no-decision-table-key", process, (BaseElement)task, "No decision table reference key is defined on the dmn activity");
        }
    }

    protected void validateFieldDeclarationsForHttp(Process process, TaskWithFieldExtensions task, List<FieldExtension> fieldExtensions, List<ValidationError> errors) {
        boolean requestMethodDefined = false;
        boolean requestUrlDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            String fieldName = fieldExtension.getFieldName();
            String fieldValue = fieldExtension.getStringValue();
            String fieldExpression = fieldExtension.getExpression();
            if ("requestMethod".equals(fieldName) && (fieldValue != null && fieldValue.length() > 0 || fieldExpression != null && fieldExpression.length() > 0)) {
                requestMethodDefined = true;
            }
            if (!"requestUrl".equals(fieldName) || (fieldValue == null || fieldValue.length() <= 0) && (fieldExpression == null || fieldExpression.length() <= 0)) continue;
            requestUrlDefined = true;
        }
        if (!requestMethodDefined) {
            this.addError(errors, "flowable-httptask-no-request-method", process, (BaseElement)task, "No request method is defined on the http activity");
        }
        if (!requestUrlDefined) {
            this.addError(errors, "flowable-httptask-no-request-url", process, (BaseElement)task, "No request url is defined on the http activity");
        }
    }

    protected void validateFieldDeclarationsForCase(Process process, CaseServiceTask caseServiceTask, List<ValidationError> errors) {
        if (StringUtils.isEmpty((CharSequence)caseServiceTask.getCaseDefinitionKey())) {
            this.addError(errors, "flowable-casetask-no-case-definition-key", process, (BaseElement)caseServiceTask, "No case definition key is defined on the case task");
        }
    }

    protected void validateFieldDeclarationsForSendEventTask(Process process, SendEventServiceTask sendEventServiceTask, List<ValidationError> errors) {
        List systemChannelElements;
        List channelKeyExtensionElements;
        if (StringUtils.isEmpty((CharSequence)sendEventServiceTask.getEventType())) {
            this.addError(errors, "flowable-sendeventtask-no-event-type", process, (BaseElement)sendEventServiceTask, "No event type is defined on the send event task");
        }
        if (((channelKeyExtensionElements = (List)sendEventServiceTask.getExtensionElements().get("channelKey")) == null || channelKeyExtensionElements.isEmpty() || StringUtils.isEmpty((CharSequence)((ExtensionElement)channelKeyExtensionElements.get(0)).getElementText())) && ((systemChannelElements = (List)sendEventServiceTask.getExtensionElements().get("systemChannel")) == null || systemChannelElements.isEmpty())) {
            this.addError(errors, "flowable-sendeventtask-no-outbound-channel", process, (BaseElement)sendEventServiceTask, "No outbound channel set on the send event task");
        }
    }

    protected void validateExternalWorkerTask(Process process, ExternalWorkerServiceTask externalWorkerServiceTask, List<ValidationError> errors) {
        if (StringUtils.isEmpty((CharSequence)externalWorkerServiceTask.getTopic())) {
            this.addError(errors, "flowable-externalworkertask-no-topic", process, (BaseElement)externalWorkerServiceTask, "No topic is defined on the external worker task");
        }
    }
}

