/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.security;

import java.util.ArrayList;
import java.util.List;
import org.flowable.engine.IdentityService;
import org.flowable.idm.api.Group;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class BasicAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    private IdentityService identityService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String password;
        String name = authentication.getName();
        boolean authenticated = this.identityService.checkPassword(name, password = authentication.getCredentials().toString());
        if (authenticated) {
            List groups = this.identityService.createGroupQuery().groupMember(name).list();
            ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
            for (Group group : groups) {
                grantedAuthorities.add(new SimpleGrantedAuthority(group.getId()));
            }
            this.identityService.setAuthenticatedUserId(name);
            return new UsernamePasswordAuthenticationToken((Object)name, (Object)password, grantedAuthorities);
        }
        throw new BadCredentialsException("Authentication failed for this username and password");
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

