/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.engine.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.rest.variable.EngineRestVariable;

public class RestVariable
extends EngineRestVariable {
    private RestVariableScope variableScope;

    @JsonIgnore
    public RestVariableScope getVariableScope() {
        return this.variableScope;
    }

    public void setVariableScope(RestVariableScope variableScope) {
        this.variableScope = variableScope;
    }

    public String getScope() {
        String scope = null;
        if (this.variableScope != null) {
            scope = this.variableScope.name().toLowerCase();
        }
        return scope;
    }

    public void setScope(String scope) {
        this.setVariableScope(RestVariable.getScopeFromString(scope));
    }

    public static RestVariableScope getScopeFromString(String scope) {
        if (scope != null) {
            for (RestVariableScope s : RestVariableScope.values()) {
                if (!s.name().equalsIgnoreCase(scope)) continue;
                return s;
            }
            throw new FlowableIllegalArgumentException("Invalid variable scope: '" + scope + "'");
        }
        return null;
    }

    public static enum RestVariableScope {
        LOCAL,
        GLOBAL;

    }
}

