/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.form;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.FormService;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.form.FormData;
import org.flowable.engine.form.TaskFormData;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.form.FormDataResponse;
import org.flowable.rest.service.api.form.RestFormProperty;
import org.flowable.rest.service.api.form.SubmitFormRequest;
import org.flowable.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Forms"}, description="Manage Forms", authorizations={@Authorization(value="basicAuth")})
public class FormDataResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected FormService formService;

    @ApiOperation(value="Get form data", tags={"Forms"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates that form data could be queried."), @ApiResponse(code=404, message="Indicates that form data could not be found.")})
    @RequestMapping(value={"/form/form-data"}, method={RequestMethod.GET}, produces={"application/json"})
    public FormDataResponse getFormData(@RequestParam(value="taskId", required=false) String taskId, @RequestParam(value="processDefinitionId", required=false) String processDefinitionId, HttpServletRequest request) {
        if (taskId == null && processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("The taskId or processDefinitionId parameter has to be provided");
        }
        if (taskId != null && processDefinitionId != null) {
            throw new FlowableIllegalArgumentException("Not both a taskId and a processDefinitionId parameter can be provided");
        }
        TaskFormData formData = null;
        String id = null;
        if (taskId != null) {
            formData = this.formService.getTaskFormData(taskId);
            id = taskId;
        } else {
            formData = this.formService.getStartFormData(processDefinitionId);
            id = processDefinitionId;
        }
        if (formData == null) {
            throw new FlowableObjectNotFoundException("Could not find a form data with id '" + id + "'.", FormData.class);
        }
        return this.restResponseFactory.createFormDataResponse((FormData)formData);
    }

    @ApiOperation(value="Submit task form data", tags={"Forms"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the form data was submitted"), @ApiResponse(code=400, message="Indicates an parameter was passed in the wrong format. The status-message contains additional information.")})
    @RequestMapping(value={"/form/form-data"}, method={RequestMethod.POST}, produces={"application/json"})
    public ProcessInstanceResponse submitForm(@RequestBody SubmitFormRequest submitRequest, HttpServletRequest request, HttpServletResponse response) {
        if (submitRequest == null) {
            throw new FlowableException("A request body was expected when executing the form submit.");
        }
        if (submitRequest.getTaskId() == null && submitRequest.getProcessDefinitionId() == null) {
            throw new FlowableIllegalArgumentException("The taskId or processDefinitionId property has to be provided");
        }
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (submitRequest.getProperties() != null) {
            for (RestFormProperty formProperty : submitRequest.getProperties()) {
                propertyMap.put(formProperty.getId(), formProperty.getValue());
            }
        }
        if (submitRequest.getTaskId() != null) {
            this.formService.submitTaskFormData(submitRequest.getTaskId(), propertyMap);
            response.setStatus(HttpStatus.NO_CONTENT.value());
            return null;
        }
        ProcessInstance processInstance = null;
        processInstance = submitRequest.getBusinessKey() != null ? this.formService.submitStartFormData(submitRequest.getProcessDefinitionId(), submitRequest.getBusinessKey(), propertyMap) : this.formService.submitStartFormData(submitRequest.getProcessDefinitionId(), propertyMap);
        return this.restResponseFactory.createProcessInstanceResponse(processInstance);
    }
}

