/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.HistoryService;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.engine.variable.RestVariable;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History"}, description="Manage History", authorizations={@Authorization(value="basicAuth")})
public class HistoricVariableInstanceDataResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;

    @RequestMapping(value={"/history/historic-variable-instances/{varInstanceId}/data"}, method={RequestMethod.GET})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the variable instance was found and the requested variable data is returned."), @ApiResponse(code=404, message="Indicates the requested variable instance was not found or the variable instance doesn\u2019t have a variable with the given name or the variable doesn\u2019t have a binary stream available. Status message provides additional information.")})
    @ApiOperation(value="Get the binary data for a historic task instance variable", tags={"History"}, nickname="getHistoricInstanceVariableData", notes="The response body contains the binary value of the variable. When the variable is of type binary, the content-type of the response is set to application/octet-stream, regardless of the content of the variable or the request accept-type header. In case of serializable, application/x-java-serialized-object is used as content-type.")
    @ResponseBody
    public byte[] getVariableData(@ApiParam(name="varInstanceId") @PathVariable(value="varInstanceId") String varInstanceId, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] result = null;
            RestVariable variable = this.getVariableFromRequest(true, varInstanceId, request);
            if ("binary".equals(variable.getType())) {
                result = (byte[])variable.getValue();
                response.setContentType("application/octet-stream");
            } else if ("serializable".equals(variable.getType())) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
                outputStream.writeObject(variable.getValue());
                outputStream.close();
                result = buffer.toByteArray();
                response.setContentType("application/x-java-serialized-object");
            } else {
                throw new FlowableObjectNotFoundException("The variable does not have a binary data stream.", null);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new FlowableException("Unexpected exception getting variable data", (Throwable)ioe);
        }
    }

    public RestVariable getVariableFromRequest(boolean includeBinary, String varInstanceId, HttpServletRequest request) {
        HistoricVariableInstance varObject = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().id(varInstanceId).singleResult();
        if (varObject == null) {
            throw new FlowableObjectNotFoundException("Historic variable instance '" + varInstanceId + "' couldn't be found.", VariableInstanceEntity.class);
        }
        return this.restResponseFactory.createRestVariable(varObject.getVariableName(), varObject.getValue(), null, varInstanceId, 6, includeBinary);
    }
}

