/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.rest.service.api.engine.RestIdentityLink;
import org.flowable.rest.service.api.repository.BaseProcessDefinitionResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Definitions"}, description="Manage Process Definitions", authorizations={@Authorization(value="basicAuth")})
public class ProcessDefinitionIdentityLinkResource
extends BaseProcessDefinitionResource {
    @ApiOperation(value="Get a candidate starter from a process definition", tags={"Process Definitions"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the process definition was found and the identity link was returned."), @ApiResponse(code=404, message="Indicates the requested process definition was not found or the process definition doesn\u2019t have an identity-link that matches the url.")})
    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}/identitylinks/{family}/{identityId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public RestIdentityLink getIdentityLink(@ApiParam(name="processDefinitionId") @PathVariable(value="processDefinitionId") String processDefinitionId, @ApiParam(name="family") @PathVariable(value="family") String family, @ApiParam(name="identityId") @PathVariable(value="identityId") String identityId, HttpServletRequest request) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        this.validateIdentityLinkArguments(family, identityId);
        IdentityLink link = this.getIdentityLink(family, identityId, processDefinition.getId());
        return this.restResponseFactory.createRestIdentityLink(link);
    }

    @ApiOperation(value="Delete a candidate starter from a process definition", tags={"Process Definitions"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the process definition was found and the identity link was removed. The response body is intentionally empty."), @ApiResponse(code=404, message="Indicates the requested process definition was not found or the process definition doesn\u2019t have an identity-link that matches the url.")})
    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}/identitylinks/{family}/{identityId}"}, method={RequestMethod.DELETE})
    public void deleteIdentityLink(@ApiParam(name="processDefinitionId") @PathVariable(value="processDefinitionId") String processDefinitionId, @ApiParam(name="family") @PathVariable(value="family") String family, @ApiParam(name="identityId") @PathVariable(value="identityId") String identityId, HttpServletResponse response) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        this.validateIdentityLinkArguments(family, identityId);
        IdentityLink link = this.getIdentityLink(family, identityId, processDefinition.getId());
        if (link.getUserId() != null) {
            this.repositoryService.deleteCandidateStarterUser(processDefinition.getId(), link.getUserId());
        } else {
            this.repositoryService.deleteCandidateStarterGroup(processDefinition.getId(), link.getGroupId());
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void validateIdentityLinkArguments(String family, String identityId) {
        if (family == null || !"groups".equals(family) && !"users".equals(family)) {
            throw new FlowableIllegalArgumentException("Identity link family should be 'users' or 'groups'.");
        }
        if (identityId == null) {
            throw new FlowableIllegalArgumentException("IdentityId is required.");
        }
    }

    protected IdentityLink getIdentityLink(String family, String identityId, String processDefinitionId) {
        boolean isUser = family.equals("users");
        List allLinks = this.repositoryService.getIdentityLinksForProcessDefinition(processDefinitionId);
        for (IdentityLink link : allLinks) {
            boolean rightIdentity = false;
            rightIdentity = isUser ? identityId.equals(link.getUserId()) : identityId.equals(link.getGroupId());
            if (!rightIdentity || !link.getType().equals("candidate")) continue;
            return link;
        }
        throw new FlowableObjectNotFoundException("Could not find the requested identity link.", IdentityLink.class);
    }
}

