/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.runtime.Execution;
import org.flowable.rest.service.api.engine.variable.RestVariable;
import org.flowable.rest.service.api.runtime.process.BaseExecutionVariableResource;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@Api(tags={"Process Instances"}, description="Manage Process Instances", authorizations={@Authorization(value="basicAuth")})
public class ProcessInstanceVariableResource
extends BaseExecutionVariableResource {
    @Autowired
    protected ObjectMapper objectMapper;

    @ApiOperation(value="Get a variable for a process instance", tags={"Process Instances"}, nickname="getProcessInstanceVariable")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates both the process instance and variable were found and variable is returned."), @ApiResponse(code=404, message="Indicates the requested process instance was not found or the process instance does not have a variable with the given name. Status description contains additional information about the error.")})
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/variables/{variableName}"}, method={RequestMethod.GET}, produces={"application/json"})
    public RestVariable getVariable(@ApiParam(name="processInstanceId") @PathVariable(value="processInstanceId") String processInstanceId, @ApiParam(name="variableName") @PathVariable(value="variableName") String variableName, @RequestParam(value="scope", required=false) String scope, HttpServletRequest request) {
        Execution execution = this.getProcessInstanceFromRequest(processInstanceId);
        return this.getVariableFromRequest(execution, variableName, scope, false);
    }

    @ApiOperation(value="Update a single variable on a process instance", tags={"Process Instances"}, nickname="updateProcessInstanceVariable")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates both the process instance and variable were found and variable is updated."), @ApiResponse(code=404, message="Indicates the requested process instance was not found or the process instance does not have a variable with the given name. Status description contains additional information about the error.")})
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/variables/{variableName}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public RestVariable updateVariable(@ApiParam(name="processInstanceId") @PathVariable(value="processInstanceId") String processInstanceId, @ApiParam(name="variableName") @PathVariable(value="variableName") String variableName, HttpServletRequest request) {
        Execution execution = this.getProcessInstanceFromRequest(processInstanceId);
        RestVariable result = null;
        if (request instanceof MultipartHttpServletRequest) {
            result = this.setBinaryVariable((MultipartHttpServletRequest)request, execution, 3, false);
            if (!result.getName().equals(variableName)) {
                throw new FlowableIllegalArgumentException("Variable name in the body should be equal to the name used in the requested URL.");
            }
        } else {
            RestVariable restVariable = null;
            try {
                restVariable = (RestVariable)((Object)this.objectMapper.readValue((InputStream)request.getInputStream(), RestVariable.class));
            }
            catch (Exception e) {
                throw new FlowableIllegalArgumentException("request body could not be transformed to a RestVariable instance.");
            }
            if (restVariable == null) {
                throw new FlowableException("Invalid body was supplied");
            }
            if (!restVariable.getName().equals(variableName)) {
                throw new FlowableIllegalArgumentException("Variable name in the body should be equal to the name used in the requested URL.");
            }
            result = this.setSimpleVariable(restVariable, execution, false);
        }
        return result;
    }

    @ApiOperation(value="Delete a variable", tags={"Process Instances"}, nickname="deleteProcessInstanceVariable")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the variable was found and has been deleted. Response-body is intentionally empty."), @ApiResponse(code=404, message="Indicates the requested variable was not found.")})
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/variables/{variableName}"}, method={RequestMethod.DELETE})
    public void deleteVariable(@ApiParam(name="processInstanceId") @PathVariable(value="processInstanceId") String processInstanceId, @ApiParam(name="variableName") @PathVariable(value="variableName") String variableName, @RequestParam(value="scope", required=false) String scope, HttpServletResponse response) {
        Execution execution = this.getProcessInstanceFromRequest(processInstanceId);
        RestVariable.RestVariableScope variableScope = RestVariable.RestVariableScope.LOCAL;
        if (scope != null) {
            variableScope = RestVariable.getScopeFromString(scope);
        }
        if (!this.hasVariableOnScope(execution, variableName, variableScope)) {
            throw new FlowableObjectNotFoundException("Execution '" + execution.getId() + "' doesn't have a variable '" + variableName + "' in scope " + variableScope.name().toLowerCase(), VariableInstanceEntity.class);
        }
        if (variableScope == RestVariable.RestVariableScope.LOCAL) {
            this.runtimeService.removeVariableLocal(execution.getId(), variableName);
        } else {
            this.runtimeService.removeVariable(execution.getParentId(), variableName);
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @Override
    protected RestVariable constructRestVariable(String variableName, Object value, RestVariable.RestVariableScope variableScope, String executionId, boolean includeBinary) {
        return this.restResponseFactory.createRestVariable(variableName, value, null, executionId, 3, includeBinary);
    }
}

