/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.task;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.task.Comment;
import org.flowable.rest.service.api.engine.CommentResponse;
import org.flowable.rest.service.api.runtime.task.TaskBaseResource;
import org.flowable.task.api.Task;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Tasks"}, description="Manage Tasks", authorizations={@Authorization(value="basicAuth")})
public class TaskCommentResource
extends TaskBaseResource {
    @ApiOperation(value=" Get a comment on a task", tags={"Tasks"}, nickname="getTaskComment")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the task and comment were found and the comment is returned."), @ApiResponse(code=404, message="Indicates the requested task was not found or the tasks doesn\u2019t have a comment with the given ID.")})
    @RequestMapping(value={"/runtime/tasks/{taskId}/comments/{commentId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public CommentResponse getComment(@ApiParam(name="taskId") @PathVariable(value="taskId") String taskId, @ApiParam(name="commentId") @PathVariable(value="commentId") String commentId, HttpServletRequest request) {
        HistoricTaskInstance task = this.getHistoricTaskFromRequest(taskId);
        Comment comment = this.taskService.getComment(commentId);
        if (comment == null || !task.getId().equals(comment.getTaskId())) {
            throw new FlowableObjectNotFoundException("Task '" + task.getId() + "' doesn't have a comment with id '" + commentId + "'.", Comment.class);
        }
        return this.restResponseFactory.createRestComment(comment);
    }

    @ApiOperation(value="Delete a comment on a task", tags={"Tasks"}, nickname="deleteTaskComment")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the task and comment were found and the comment is deleted. Response body is left empty intentionally."), @ApiResponse(code=404, message="Indicates the requested task was not found or the tasks doesn\u2019t have a comment with the given ID.")})
    @RequestMapping(value={"/runtime/tasks/{taskId}/comments/{commentId}"}, method={RequestMethod.DELETE})
    public void deleteComment(@ApiParam(name="taskId") @PathVariable(value="taskId") String taskId, @ApiParam(name="commentId") @PathVariable(value="commentId") String commentId, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        Comment comment = this.taskService.getComment(commentId);
        if (comment == null || comment.getTaskId() == null || !comment.getTaskId().equals(task.getId())) {
            throw new FlowableObjectNotFoundException("Task '" + task.getId() + "' doesn't have a comment with id '" + commentId + "'.", Comment.class);
        }
        this.taskService.deleteComment(commentId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

