/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.task;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.rest.service.api.engine.RestIdentityLink;
import org.flowable.rest.service.api.runtime.task.TaskBaseResource;
import org.flowable.task.api.Task;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Tasks"}, description="Manage Tasks", authorizations={@Authorization(value="basicAuth")})
public class TaskIdentityLinkResource
extends TaskBaseResource {
    @ApiOperation(value="Get a single identity link on a task", tags={"Tasks"}, nickname="getTaskInstanceIdentityLinks")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the task and identity link was found and returned."), @ApiResponse(code=404, message="Indicates the requested task was not found or the task doesn\u2019t have the requested identityLink. The status contains additional information about this error.")})
    @RequestMapping(value={"/runtime/tasks/{taskId}/identitylinks/{family}/{identityId}/{type}"}, method={RequestMethod.GET}, produces={"application/json"})
    public RestIdentityLink getIdentityLink(@ApiParam(name="taskId") @PathVariable(value="taskId") String taskId, @ApiParam(name="family") @PathVariable(value="family") String family, @ApiParam(name="identityId") @PathVariable(value="identityId") String identityId, @ApiParam(name="type") @PathVariable(value="type") String type, HttpServletRequest request) {
        Task task = this.getTaskFromRequest(taskId);
        this.validateIdentityLinkArguments(family, identityId, type);
        IdentityLink link = this.getIdentityLink(family, identityId, type, task.getId());
        return this.restResponseFactory.createRestIdentityLink(link);
    }

    @ApiOperation(value="Delete an identity link on a task", tags={"Tasks"}, nickname="deleteTaskInstanceIdentityLinks")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the task and identity link were found and the link has been deleted. Response-body is intentionally empty."), @ApiResponse(code=404, message="Indicates the requested task was not found or the task doesn\u2019t have the requested identityLink. The status contains additional information about this error.")})
    @RequestMapping(value={"/runtime/tasks/{taskId}/identitylinks/{family}/{identityId}/{type}"}, method={RequestMethod.DELETE})
    public void deleteIdentityLink(@ApiParam(name="taskId") @PathVariable(value="taskId") String taskId, @ApiParam(name="family") @PathVariable(value="family") String family, @ApiParam(name="identityId") @PathVariable(value="identityId") String identityId, @ApiParam(name="type") @PathVariable(value="type") String type, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        this.validateIdentityLinkArguments(family, identityId, type);
        this.getIdentityLink(family, identityId, type, task.getId());
        if ("users".equals(family)) {
            this.taskService.deleteUserIdentityLink(task.getId(), identityId, type);
        } else {
            this.taskService.deleteGroupIdentityLink(task.getId(), identityId, type);
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void validateIdentityLinkArguments(String family, String identityId, String type) {
        if (family == null || !"groups".equals(family) && !"users".equals(family)) {
            throw new FlowableIllegalArgumentException("Identity link family should be 'users' or 'groups'.");
        }
        if (identityId == null) {
            throw new FlowableIllegalArgumentException("IdentityId is required.");
        }
        if (type == null) {
            throw new FlowableIllegalArgumentException("Type is required.");
        }
    }

    protected IdentityLink getIdentityLink(String family, String identityId, String type, String taskId) {
        boolean isUser = family.equals("users");
        List allLinks = this.taskService.getIdentityLinksForTask(taskId);
        for (IdentityLink link : allLinks) {
            boolean rightIdentity = false;
            rightIdentity = isUser ? identityId.equals(link.getUserId()) : identityId.equals(link.getGroupId());
            if (!rightIdentity || !link.getType().equals(type)) continue;
            return link;
        }
        throw new FlowableObjectNotFoundException("Could not find the requested identity link.", IdentityLink.class);
    }
}

