/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.rest.service.api.history.HistoricTaskInstanceBaseResource;
import org.flowable.rest.service.api.history.HistoricTaskInstanceQueryRequest;
import org.flowable.rest.service.api.history.HistoricTaskInstanceResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History Task"}, description="Manage History Task Instances", authorizations={@Authorization(value="basicAuth")})
public class HistoricTaskInstanceQueryResource
extends HistoricTaskInstanceBaseResource {
    @ApiOperation(value="Query for historic task instances", tags={"History Task", "Query"}, nickname="queryHistoricTaskInstance", notes="All supported JSON parameter fields allowed are exactly the same as the parameters found for getting a collection of historic task instances, but passed in as JSON-body arguments rather than URL-parameters to allow for more advanced querying and preventing errors with request-uri\u2019s that are too long. On top of that, the query allows for filtering based on process variables. The taskVariables and processVariables properties are JSON-arrays containing objects with the format as described here.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the tasks are returned"), @ApiResponse(code=404, message="Indicates an parameter was passed in the wrong format. The status-message contains additional information.")})
    @PostMapping(value={"/query/historic-task-instances"}, produces={"application/json"})
    public DataResponse<HistoricTaskInstanceResponse> queryProcessInstances(@RequestBody HistoricTaskInstanceQueryRequest queryRequest, @ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        return this.getQueryResponse(queryRequest, allRequestParams, request.getRequestURL().toString().replace("/query/historic-task-instances", ""));
    }
}

