/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.api.PaginateRequest;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.ProcessInstanceQueryProperty;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceQuery;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.engine.variable.QueryVariable;
import org.flowable.rest.service.api.runtime.process.ProcessInstanceQueryRequest;
import org.flowable.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseProcessInstanceResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected DataResponse<ProcessInstanceResponse> getQueryResponse(ProcessInstanceQueryRequest queryRequest, Map<String, String> requestParams) {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getProcessInstanceIds() != null) {
            query.processInstanceIds(queryRequest.getProcessInstanceIds());
        }
        if (queryRequest.getProcessInstanceName() != null) {
            query.processInstanceName(queryRequest.getProcessInstanceName());
        }
        if (queryRequest.getProcessInstanceNameLike() != null) {
            query.processInstanceNameLike(queryRequest.getProcessInstanceNameLike());
        }
        if (queryRequest.getProcessInstanceNameLikeIgnoreCase() != null) {
            query.processInstanceNameLikeIgnoreCase(queryRequest.getProcessInstanceNameLikeIgnoreCase());
        }
        if (queryRequest.getProcessDefinitionKey() != null) {
            query.processDefinitionKey(queryRequest.getProcessDefinitionKey());
        }
        if (queryRequest.getProcessDefinitionKeys() != null) {
            query.processDefinitionKeys(queryRequest.getProcessDefinitionKeys());
        }
        if (queryRequest.getProcessDefinitionId() != null) {
            query.processDefinitionId(queryRequest.getProcessDefinitionId());
        }
        if (queryRequest.getProcessDefinitionIds() != null) {
            query.processDefinitionIds(queryRequest.getProcessDefinitionIds());
        }
        if (queryRequest.getProcessDefinitionCategory() != null) {
            query.processDefinitionCategory(queryRequest.getProcessDefinitionCategory());
        }
        if (queryRequest.getProcessDefinitionName() != null) {
            query.processDefinitionName(queryRequest.getProcessDefinitionName());
        }
        if (queryRequest.getProcessDefinitionVersion() != null) {
            query.processDefinitionVersion(queryRequest.getProcessDefinitionVersion());
        }
        if (queryRequest.getProcessDefinitionEngineVersion() != null) {
            query.processDefinitionEngineVersion(queryRequest.getProcessDefinitionEngineVersion());
        }
        if (queryRequest.getDeploymentId() != null) {
            query.deploymentId(queryRequest.getDeploymentId());
        }
        if (queryRequest.getDeploymentIdIn() != null) {
            query.deploymentIdIn(queryRequest.getDeploymentIdIn());
        }
        if (queryRequest.getProcessBusinessKey() != null) {
            query.processInstanceBusinessKey(queryRequest.getProcessBusinessKey());
        }
        if (queryRequest.getStartedBy() != null) {
            query.startedBy(queryRequest.getStartedBy());
        }
        if (queryRequest.getStartedBefore() != null) {
            query.startedBefore(queryRequest.getStartedBefore());
        }
        if (queryRequest.getStartedAfter() != null) {
            query.startedAfter(queryRequest.getStartedAfter());
        }
        if (queryRequest.getInvolvedUser() != null) {
            query.involvedUser(queryRequest.getInvolvedUser());
        }
        if (queryRequest.getSuspended() != null) {
            if (queryRequest.getSuspended().booleanValue()) {
                query.suspended();
            } else {
                query.active();
            }
        }
        if (queryRequest.getSubProcessInstanceId() != null) {
            query.subProcessInstanceId(queryRequest.getSubProcessInstanceId());
        }
        if (queryRequest.getSuperProcessInstanceId() != null) {
            query.superProcessInstanceId(queryRequest.getSuperProcessInstanceId());
        }
        if (queryRequest.getExcludeSubprocesses() != null) {
            query.excludeSubprocesses(queryRequest.getExcludeSubprocesses().booleanValue());
        }
        if (queryRequest.getIncludeProcessVariables() != null && queryRequest.getIncludeProcessVariables().booleanValue()) {
            query.includeProcessVariables();
        }
        if (queryRequest.getVariables() != null) {
            this.addVariables(query, queryRequest.getVariables());
        }
        if (queryRequest.getCallbackId() != null) {
            query.processInstanceCallbackId(queryRequest.getCallbackId());
        }
        if (queryRequest.getCallbackType() != null) {
            query.processInstanceCallbackType(queryRequest.getCallbackType());
        }
        if (queryRequest.getTenantId() != null) {
            query.processInstanceTenantId(queryRequest.getTenantId());
        }
        if (queryRequest.getTenantIdLike() != null) {
            query.processInstanceTenantIdLike(queryRequest.getTenantIdLike());
        }
        if (Boolean.TRUE.equals(queryRequest.getWithoutTenantId())) {
            query.processInstanceWithoutTenantId();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessProcessInstanceInfoWithQuery(query, queryRequest);
        }
        DataResponse responseList = PaginateListUtil.paginateList(requestParams, (PaginateRequest)queryRequest, (Query)query, (String)"id", allowedSortProperties, this.restResponseFactory::createProcessInstanceResponseList);
        HashSet<String> processDefinitionIds = new HashSet<String>();
        List processInstanceList = responseList.getData();
        for (ProcessInstanceResponse processInstanceResponse : processInstanceList) {
            if (processDefinitionIds.contains(processInstanceResponse.getProcessDefinitionId())) continue;
            processDefinitionIds.add(processInstanceResponse.getProcessDefinitionId());
        }
        if (processDefinitionIds.size() > 0) {
            List processDefinitionList = this.repositoryService.createProcessDefinitionQuery().processDefinitionIds(processDefinitionIds).list();
            HashMap<String, ProcessDefinition> processDefinitionMap = new HashMap<String, ProcessDefinition>();
            for (ProcessDefinition processDefinition : processDefinitionList) {
                processDefinitionMap.put(processDefinition.getId(), processDefinition);
            }
            for (ProcessInstanceResponse processInstanceResponse : processInstanceList) {
                if (!processDefinitionMap.containsKey(processInstanceResponse.getProcessDefinitionId())) continue;
                ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionMap.get(processInstanceResponse.getProcessDefinitionId());
                processInstanceResponse.setProcessDefinitionName(processDefinition.getName());
                processInstanceResponse.setProcessDefinitionDescription(processDefinition.getDescription());
            }
        }
        return responseList;
    }

    protected void addVariables(ProcessInstanceQuery processInstanceQuery, List<QueryVariable> variables) {
        block11: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new FlowableIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new FlowableIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess && variable.getVariableOperation() != QueryVariable.QueryVariableOperation.EQUALS) {
                throw new FlowableIllegalArgumentException("Value-only query (without a variable-name) is only supported when using 'equals' operation.");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    if (nameLess) {
                        processInstanceQuery.variableValueEquals(actualValue);
                        continue block11;
                    }
                    processInstanceQuery.variableValueEquals(variable.getName(), actualValue);
                    continue block11;
                }
                case EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        processInstanceQuery.variableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case NOT_EQUALS: {
                    processInstanceQuery.variableValueNotEquals(variable.getName(), actualValue);
                    continue block11;
                }
                case NOT_EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        processInstanceQuery.variableValueNotEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case LIKE: {
                    if (actualValue instanceof String) {
                        processInstanceQuery.variableValueLike(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported for like, but was: " + actualValue.getClass().getName());
                }
                case GREATER_THAN: {
                    processInstanceQuery.variableValueGreaterThan(variable.getName(), actualValue);
                    continue block11;
                }
                case GREATER_THAN_OR_EQUALS: {
                    processInstanceQuery.variableValueGreaterThanOrEqual(variable.getName(), actualValue);
                    continue block11;
                }
                case LESS_THAN: {
                    processInstanceQuery.variableValueLessThan(variable.getName(), actualValue);
                    continue block11;
                }
                case LESS_THAN_OR_EQUALS: {
                    processInstanceQuery.variableValueLessThanOrEqual(variable.getName(), actualValue);
                    continue block11;
                }
            }
            throw new FlowableIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    protected ProcessInstance getProcessInstanceFromRequest(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a process instance with id '" + processInstanceId + "'.");
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessProcessInstanceInfoById(processInstance);
        }
        return processInstance;
    }

    static {
        allowedSortProperties.put("processDefinitionId", (QueryProperty)ProcessInstanceQueryProperty.PROCESS_DEFINITION_ID);
        allowedSortProperties.put("processDefinitionKey", (QueryProperty)ProcessInstanceQueryProperty.PROCESS_DEFINITION_KEY);
        allowedSortProperties.put("id", (QueryProperty)ProcessInstanceQueryProperty.PROCESS_INSTANCE_ID);
        allowedSortProperties.put("startTime", (QueryProperty)ProcessInstanceQueryProperty.PROCESS_START_TIME);
        allowedSortProperties.put("tenantId", (QueryProperty)ProcessInstanceQueryProperty.TENANT_ID);
    }
}

