/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import javax.persistence.EntityManagerFactory;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(type={"javax.persistence.EntityManagerFactory"})
@ConditionalOnClass(value={SpringProcessEngineConfiguration.class})
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
public class FlowableJpaAutoConfiguration {
    @ConditionalOnMissingBean(name={"jpaProcessEngineConfigurer"})
    @Bean
    public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> jpaProcessEngineConfigurer(EntityManagerFactory emf) {
        return processEngineConfiguration -> {
            processEngineConfiguration.setJpaEntityManagerFactory((Object)emf);
            processEngineConfiguration.setJpaHandleTransaction(false);
            processEngineConfiguration.setJpaCloseEntityManager(false);
        };
    }
}

