/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.conf;

import java.util.Collections;
import org.flowable.ui.admin.security.AjaxLogoutSuccessHandler;
import org.flowable.ui.admin.security.RemoteIdmAuthenticationProvider;
import org.flowable.ui.common.filter.FlowableCookieFilterRegistrationBean;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.security.ActuatorRequestMatcher;
import org.flowable.ui.common.security.ClearFlowableCookieLogoutHandler;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.info.InfoEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class SecurityConfiguration {
    @Autowired
    private RemoteIdmAuthenticationProvider authenticationProvider;

    @Bean
    public FlowableCookieFilterRegistrationBean flowableCookieFilterRegistrationBean(RemoteIdmService remoteIdmService, FlowableCommonAppProperties properties) {
        FlowableCookieFilterRegistrationBean registrationBean = new FlowableCookieFilterRegistrationBean(remoteIdmService, properties);
        registrationBean.addUrlPatterns(new String[]{"/app/*"});
        registrationBean.setRequiredPrivileges(Collections.singletonList("access-admin"));
        return registrationBean;
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider((AuthenticationProvider)this.authenticationProvider);
    }

    @ConditionalOnClass(value={EndpointRequest.class})
    @Configuration
    @Order(value=5)
    public static class ActuatorWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable();
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.requestMatcher((RequestMatcher)new ActuatorRequestMatcher()).authorizeRequests().requestMatchers(new RequestMatcher[]{EndpointRequest.to((Class[])new Class[]{InfoEndpoint.class, HealthEndpoint.class})})).authenticated().requestMatchers(new RequestMatcher[]{EndpointRequest.toAnyEndpoint()})).hasAnyAuthority(new String[]{"access-admin"}).and()).httpBasic();
        }
    }

    @Configuration
    @Order(value=10)
    public static class FormLoginWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        protected FlowableCookieFilterRegistrationBean flowableCookieFilterRegistrationBean;
        @Autowired
        private AjaxLogoutSuccessHandler ajaxLogoutSuccessHandler;

        protected void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.addFilterBefore(this.flowableCookieFilterRegistrationBean.getFilter(), UsernamePasswordAuthenticationFilter.class).logout().logoutUrl("/app/logout").logoutSuccessHandler((LogoutSuccessHandler)this.ajaxLogoutSuccessHandler).addLogoutHandler((LogoutHandler)new ClearFlowableCookieLogoutHandler()).deleteCookies(new String[]{"FLOWABLE_REMEMBER_ME"}).and()).csrf().disable()).authorizeRequests().antMatchers(new String[]{"/app/rest/**"})).hasAuthority("access-admin");
        }
    }
}

