/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.repository;

import java.util.List;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.repository.ServerConfigRepository;
import org.flowable.ui.common.repository.UuidIdGenerator;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerConfigRepositoryImpl
implements ServerConfigRepository {
    private static final String NAMESPACE = "org.flowable.ui.admin.domain.ServerConfig.";
    @Autowired
    protected SqlSessionTemplate sqlSessionTemplate;
    @Autowired
    protected UuidIdGenerator idGenerator;

    @Override
    public ServerConfig get(String id) {
        return (ServerConfig)this.sqlSessionTemplate.selectOne("org.flowable.ui.admin.domain.ServerConfig.selectServerConfig", (Object)id);
    }

    @Override
    public List<ServerConfig> getAll() {
        return this.sqlSessionTemplate.selectList("org.flowable.ui.admin.domain.ServerConfig.selectAllServerConfigs");
    }

    @Override
    public List<ServerConfig> getByEndpointType(EndpointType endpointType) {
        return this.sqlSessionTemplate.selectList("org.flowable.ui.admin.domain.ServerConfig.selectAllServerConfigsByEndpointType", (Object)endpointType.getEndpointCode());
    }

    @Override
    public void save(ServerConfig serverConfig) {
        if (serverConfig.getId() == null) {
            serverConfig.setId(this.idGenerator.generateId());
            this.sqlSessionTemplate.insert("org.flowable.ui.admin.domain.ServerConfig.insertServerConfig", (Object)serverConfig);
        } else {
            this.sqlSessionTemplate.update("org.flowable.ui.admin.domain.ServerConfig.updateServerConfig", (Object)serverConfig);
        }
    }
}

