/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.flowable.ui.admin.properties.FlowableAdminAppProperties;

public abstract class AbstractEncryptingService {
    public static final String UTF8_ENCODING = "UTF-8";
    public static final String AES_KEY = "AES";
    public static final String AES_CYPHER = "AES/CBC/PKCS5PADDING";
    protected IvParameterSpec initializationVectorSpec;
    protected SecretKeySpec secretKeySpec;

    protected AbstractEncryptingService(FlowableAdminAppProperties properties) {
        FlowableAdminAppProperties.Encryption encryption = properties.getSecurity().getEncryption();
        String ivString = encryption.getCredentialsIVSpec();
        String secretString = encryption.getCredentialsSecretSpec();
        try {
            this.initializationVectorSpec = new IvParameterSpec(ivString.getBytes(UTF8_ENCODING));
            this.secretKeySpec = new SecretKeySpec(secretString.getBytes(UTF8_ENCODING), AES_KEY);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String encrypt(String value) {
        try {
            Cipher cipher = Cipher.getInstance(AES_CYPHER);
            cipher.init(1, (Key)this.secretKeySpec, this.initializationVectorSpec);
            byte[] encrypted = cipher.doFinal(value.getBytes());
            return new String(Base64.getEncoder().encode(encrypted), UTF8_ENCODING);
        }
        catch (GeneralSecurityException nsae) {
            throw new RuntimeException(nsae);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    protected String decrypt(String encrypted) {
        try {
            Cipher cipher = Cipher.getInstance(AES_CYPHER);
            cipher.init(2, (Key)this.secretKeySpec, this.initializationVectorSpec);
            byte[] original = cipher.doFinal(Base64.getDecoder().decode(encrypted.getBytes(UTF8_ENCODING)));
            return new String(original, UTF8_ENCODING);
        }
        catch (GeneralSecurityException nsae) {
            throw new RuntimeException(nsae);
        }
        catch (UnsupportedEncodingException usee) {
            throw new RuntimeException(usee);
        }
    }
}

