/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.service.keycloak;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.flowable.common.engine.api.FlowableException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class KeycloakConfiguration
implements InitializingBean {
    protected String server;
    protected String authenticationRealm = "master";
    protected String authenticationUser = "admin";
    protected String authenticationPassword;
    protected String realm;
    protected Duration clockSkew = Duration.ofSeconds(60L);
    protected Clock clock = Clock.systemUTC();
    protected RestTemplate restTemplate;

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.server, (String)"server must be set");
        Assert.hasText((String)this.authenticationPassword, (String)"authenticationPassword must be set");
        Assert.hasText((String)this.realm, (String)"realm must be set");
        if (this.restTemplate == null) {
            this.restTemplate = new RestTemplate();
            this.restTemplate.getInterceptors().add(new AuthenticationTokenInterceptor());
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        Assert.notNull((Object)this.clock, (String)"authenticationServer cannot be null");
        this.server = server.endsWith("/") ? server : server + "/";
    }

    public String getAuthenticationRealm() {
        return this.authenticationRealm;
    }

    public void setAuthenticationRealm(String authenticationRealm) {
        Assert.notNull((Object)this.clock, (String)"authenticationRealm cannot be null");
        this.authenticationRealm = authenticationRealm;
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        Assert.notNull((Object)this.clock, (String)"authenticationUser cannot be null");
        this.authenticationUser = authenticationUser;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        Assert.notNull((Object)this.clock, (String)"authenticationPassword cannot be null");
        this.authenticationPassword = authenticationPassword;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        Assert.notNull((Object)this.clock, (String)"realm cannot be null");
        this.realm = realm;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        Assert.notNull((Object)this.clock, (String)"restTemplate cannot be null");
        this.restTemplate = restTemplate;
    }

    public Duration getClockSkew() {
        return this.clockSkew;
    }

    public void setClockSkew(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, (String)"clockSkew cannot be null");
        Assert.isTrue((clockSkew.getSeconds() >= 0L ? 1 : 0) != 0, (String)"clockSkew must be >= 0");
        this.clockSkew = clockSkew;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    public static class AccessToken {
        protected final String value;
        protected final Instant expiresAt;

        public AccessToken(String value, Instant expiresAt) {
            this.value = value;
            this.expiresAt = expiresAt;
        }

        public String getValue() {
            return this.value;
        }

        public Instant getExpiresAt() {
            return this.expiresAt;
        }
    }

    public class AuthenticationTokenInterceptor
    implements ClientHttpRequestInterceptor {
        protected final RestTemplate tokenRestTemplate;
        protected AccessToken accessToken;

        public AuthenticationTokenInterceptor() {
            this.accessToken = new AccessToken(null, KeycloakConfiguration.this.clock.instant().minusSeconds(10L));
            this.tokenRestTemplate = new RestTemplate();
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            HttpHeaders headers = request.getHeaders();
            if (!headers.containsKey((Object)"Authorization")) {
                headers.setBearerAuth(this.getAccessTokenValue());
            }
            return execution.execute(request, body);
        }

        public String getAccessTokenValue() {
            String accessTokenValue;
            if (this.hasTokenExpired()) {
                AccessToken accessToken;
                this.accessToken = accessToken = this.fetchAccessToken();
                accessTokenValue = accessToken.getValue();
            } else {
                accessTokenValue = this.accessToken.getValue();
            }
            return accessTokenValue;
        }

        public AccessToken fetchAccessToken() {
            HttpHeaders tokenHeaders = new HttpHeaders();
            tokenHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap tokenRequestBody = new LinkedMultiValueMap();
            tokenRequestBody.add((Object)"username", (Object)KeycloakConfiguration.this.getAuthenticationUser());
            tokenRequestBody.add((Object)"password", (Object)KeycloakConfiguration.this.getAuthenticationPassword());
            tokenRequestBody.add((Object)"grant_type", (Object)"password");
            tokenRequestBody.add((Object)"client_id", (Object)"admin-cli");
            HttpEntity tokenRequest = new HttpEntity((Object)tokenRequestBody, (MultiValueMap)tokenHeaders);
            ResponseEntity tokenResponse = this.tokenRestTemplate.postForEntity(KeycloakConfiguration.this.getServer() + "auth/realms/{realm}/protocol/openid-connect/token", (Object)tokenRequest, JsonNode.class, new Object[]{KeycloakConfiguration.this.getAuthenticationRealm()});
            HttpStatus statusCode = tokenResponse.getStatusCode();
            if (statusCode.is2xxSuccessful()) {
                JsonNode body = (JsonNode)tokenResponse.getBody();
                if (body != null) {
                    String accessToken = body.path("access_token").asText(null);
                    long expiresIn = body.path("expires_in").asLong(0L);
                    Instant expiresAt = Instant.now().plusSeconds(expiresIn > 0L ? expiresIn : 1L);
                    return new AccessToken(accessToken, expiresAt);
                }
                throw new FlowableException("Could not get access token");
            }
            throw new FlowableException("Could not get access token. Status code: " + statusCode + ". Token response: " + tokenResponse.getBody());
        }

        protected boolean hasTokenExpired() {
            return KeycloakConfiguration.this.clock.instant().isAfter(this.accessToken.getExpiresAt().minus(KeycloakConfiguration.this.clockSkew));
        }
    }
}

