/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.editor.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.ui.task.service.editor.mapper.InfoMapper;

public abstract class AbstractInfoMapper
implements InfoMapper {
    protected DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected ArrayNode propertiesNode;

    @Override
    public ArrayNode map(Object element) {
        this.propertiesNode = this.objectMapper.createArrayNode();
        if (element instanceof FlowElement) {
            FlowElement flowElement = (FlowElement)element;
            if (StringUtils.isNotEmpty((CharSequence)flowElement.getDocumentation())) {
                this.createPropertyNode("Documentation", flowElement.getDocumentation());
            }
            if (element instanceof Activity) {
                Activity activity = (Activity)element;
                if (activity.getLoopCharacteristics() != null) {
                    MultiInstanceLoopCharacteristics multiInstanceDef = activity.getLoopCharacteristics();
                    this.createPropertyNode("Multi-instance activity", "");
                    this.createPropertyNode("Sequential", multiInstanceDef.isSequential());
                    if (StringUtils.isNotEmpty((CharSequence)multiInstanceDef.getInputDataItem())) {
                        this.createPropertyNode("Collection", multiInstanceDef.getInputDataItem());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)multiInstanceDef.getElementVariable())) {
                        this.createPropertyNode("Element variable", multiInstanceDef.getElementVariable());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)multiInstanceDef.getLoopCardinality())) {
                        this.createPropertyNode("Loop cardinality", multiInstanceDef.getLoopCardinality());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)multiInstanceDef.getCompletionCondition())) {
                        this.createPropertyNode("Completion condition", multiInstanceDef.getCompletionCondition());
                    }
                    this.createPropertyNode("", "");
                }
                if (StringUtils.isNotEmpty((CharSequence)activity.getDefaultFlow())) {
                    this.createPropertyNode("Default flow", activity.getDefaultFlow());
                }
            }
        }
        this.mapProperties(element);
        return this.propertiesNode;
    }

    protected abstract void mapProperties(Object var1);

    protected void createListenerPropertyNodes(String name, List<FlowableListener> listeners) {
        if (CollectionUtils.isNotEmpty(listeners)) {
            ArrayList<String> listenerValues = new ArrayList<String>();
            for (FlowableListener listener : listeners) {
                StringBuilder listenerBuilder = new StringBuilder();
                listenerBuilder.append(listener.getEvent());
                if (StringUtils.isNotEmpty((CharSequence)listener.getImplementation())) {
                    listenerBuilder.append(" - ");
                    listenerBuilder.append(listener.getImplementation());
                    listenerBuilder.append(" (");
                    listenerBuilder.append(listener.getImplementationType());
                    listenerBuilder.append(")");
                }
                if (CollectionUtils.isNotEmpty((Collection)listener.getFieldExtensions())) {
                    listenerBuilder.append(", field extensions: ");
                    for (int i = 0; i < listener.getFieldExtensions().size(); ++i) {
                        if (i > 0) {
                            listenerBuilder.append(",  ");
                        }
                        FieldExtension field = (FieldExtension)listener.getFieldExtensions().get(i);
                        listenerBuilder.append(field.getFieldName());
                        if (StringUtils.isNotEmpty((CharSequence)field.getStringValue())) {
                            listenerBuilder.append(" - ");
                            listenerBuilder.append(field.getStringValue());
                            continue;
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)field.getExpression())) continue;
                        listenerBuilder.append(" - ");
                        listenerBuilder.append(field.getExpression());
                    }
                }
                listenerValues.add(listenerBuilder.toString());
            }
            this.createPropertyNode(name, listenerValues);
        }
    }

    protected void createFieldPropertyNodes(String name, List<FieldExtension> fields) {
        if (CollectionUtils.isNotEmpty(fields)) {
            ArrayList<String> fieldValues = new ArrayList<String>();
            for (FieldExtension field : fields) {
                StringBuilder fieldBuilder = new StringBuilder();
                fieldBuilder.append(field.getFieldName());
                if (StringUtils.isNotEmpty((CharSequence)field.getStringValue())) {
                    fieldBuilder.append(" - ");
                    fieldBuilder.append(field.getStringValue());
                } else if (StringUtils.isNotEmpty((CharSequence)field.getExpression())) {
                    fieldBuilder.append(" - ");
                    fieldBuilder.append(field.getExpression());
                }
                fieldValues.add(fieldBuilder.toString());
            }
            this.createPropertyNode(name, fieldValues);
        }
    }

    protected void createPropertyNode(String name, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            ObjectNode propertyNode = this.objectMapper.createObjectNode();
            propertyNode.put("name", name);
            propertyNode.put("value", value);
            this.propertiesNode.add((JsonNode)propertyNode);
        }
    }

    protected void createPropertyNode(String name, Date value) {
        if (value != null) {
            this.createPropertyNode(name, this.dateFormat.format(value));
        }
    }

    protected void createPropertyNode(String name, Boolean value) {
        if (value != null) {
            this.createPropertyNode(name, value.toString());
        }
    }

    protected void createPropertyNode(String name, List<String> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            ArrayNode itemsNode = this.objectMapper.createArrayNode();
            for (String value : values) {
                itemsNode.add(value);
            }
            ObjectNode propertyNode = this.objectMapper.createObjectNode();
            propertyNode.put("name", name);
            propertyNode.put("type", "list");
            propertyNode.set("value", (JsonNode)itemsNode);
            this.propertiesNode.add((JsonNode)propertyNode);
        }
    }
}

