/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.runtime;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.UserTask;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnTaskService;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.identitylink.api.history.HistoricIdentityLink;
import org.flowable.idm.api.User;
import org.flowable.task.api.TaskInfo;
import org.flowable.ui.common.model.RemoteGroup;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.flowable.ui.task.model.runtime.TaskRepresentation;
import org.flowable.ui.task.service.api.UserCache;
import org.flowable.ui.task.service.runtime.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class FlowableAbstractTaskService {
    @Autowired
    protected RemoteIdmService remoteIdmService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected CmmnRepositoryService cmmnRepositoryService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected CmmnTaskService cmmnTaskService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected UserCache userCache;
    @Autowired
    protected PermissionService permissionService;

    public void fillPermissionInformation(TaskRepresentation taskRepresentation, TaskInfo task, User currentUser) {
        this.verifyProcessInstanceStartUser(taskRepresentation, task);
        List taskIdentityLinks = this.historyService.getHistoricIdentityLinksForTask(task.getId());
        this.verifyCandidateGroups(taskRepresentation, currentUser, taskIdentityLinks);
        this.verifyCandidateUsers(taskRepresentation, currentUser, taskIdentityLinks);
    }

    protected void verifyProcessInstanceStartUser(TaskRepresentation taskRepresentation, TaskInfo task) {
        HistoricProcessInstance historicProcessInstance;
        if (task.getProcessInstanceId() != null && (historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()) != null && StringUtils.isNotEmpty((CharSequence)historicProcessInstance.getStartUserId())) {
            String value;
            UserTask userTask;
            List extensionElements;
            taskRepresentation.setProcessInstanceStartUserId(historicProcessInstance.getStartUserId());
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            FlowElement flowElement = bpmnModel.getFlowElement(task.getTaskDefinitionKey());
            if (flowElement instanceof UserTask && CollectionUtils.isNotEmpty((Collection)(extensionElements = (List)(userTask = (UserTask)flowElement).getExtensionElements().get("initiator-can-complete"))) && StringUtils.isNotEmpty((CharSequence)(value = ((ExtensionElement)extensionElements.get(0)).getElementText()))) {
                taskRepresentation.setInitiatorCanCompleteTask(Boolean.valueOf(value));
            }
        }
    }

    protected void verifyCandidateGroups(TaskRepresentation taskRepresentation, User currentUser, List<HistoricIdentityLink> taskIdentityLinks) {
        List userGroups = this.remoteIdmService.getUser(currentUser.getId()).getGroups();
        taskRepresentation.setMemberOfCandidateGroup(this.userGroupsMatchTaskCandidateGroups(userGroups, taskIdentityLinks));
    }

    protected boolean userGroupsMatchTaskCandidateGroups(List<RemoteGroup> userGroups, List<HistoricIdentityLink> taskIdentityLinks) {
        for (RemoteGroup group : userGroups) {
            for (HistoricIdentityLink identityLink : taskIdentityLinks) {
                if (identityLink.getGroupId() == null || !identityLink.getType().equals("candidate") || !group.getId().equals(identityLink.getGroupId())) continue;
                return true;
            }
        }
        return false;
    }

    protected void verifyCandidateUsers(TaskRepresentation taskRepresentation, User currentUser, List<HistoricIdentityLink> taskIdentityLinks) {
        taskRepresentation.setMemberOfCandidateUsers(this.currentUserMatchesTaskCandidateUsers(currentUser, taskIdentityLinks));
    }

    protected boolean currentUserMatchesTaskCandidateUsers(User currentUser, List<HistoricIdentityLink> taskIdentityLinks) {
        for (HistoricIdentityLink identityLink : taskIdentityLinks) {
            if (identityLink.getUserId() == null || !identityLink.getType().equals("candidate") || !identityLink.getUserId().equals(currentUser.getId())) continue;
            return true;
        }
        return false;
    }
}

