/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.runtime;

import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.flowable.content.api.ContentService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.idm.api.User;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.service.exception.NotPermittedException;
import org.flowable.ui.task.model.runtime.CreateProcessInstanceRepresentation;
import org.flowable.ui.task.model.runtime.ProcessInstanceRepresentation;
import org.flowable.ui.task.service.api.UserCache;
import org.flowable.ui.task.service.runtime.FlowableCommentService;
import org.flowable.ui.task.service.runtime.PermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableProcessInstanceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableProcessInstanceService.class);
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected FormService formService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected ContentService contentService;
    @Autowired
    protected FlowableCommentService commentService;
    @Autowired
    protected UserCache userCache;

    public ProcessInstanceRepresentation getProcessInstance(String processInstanceId, HttpServletResponse response) {
        FormInfo formInfo;
        UserCache.CachedUser user;
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (!this.permissionService.hasReadPermissionOnProcessInstance(SecurityUtils.getCurrentUserObject(), processInstance, processInstanceId)) {
            throw new NotFoundException("Process with id: " + processInstanceId + " does not exist or is not available for this user");
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
        User userRep = null;
        if (processInstance.getStartUserId() != null && (user = this.userCache.getUser(processInstance.getStartUserId())) != null && user.getUser() != null) {
            userRep = user.getUser();
        }
        ProcessInstanceRepresentation processInstanceResult = new ProcessInstanceRepresentation(processInstance, (ProcessDefinition)processDefinition, processDefinition.isGraphicalNotationDefined(), userRep);
        if (processDefinition.hasStartFormKey() && (formInfo = this.runtimeService.getStartFormModel(processInstance.getProcessDefinitionId(), processInstance.getId())) != null) {
            processInstanceResult.setStartFormDefined(true);
        }
        return processInstanceResult;
    }

    public FormInfo getProcessInstanceStartForm(String processInstanceId, HttpServletResponse response) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (!this.permissionService.hasReadPermissionOnProcessInstance(SecurityUtils.getCurrentUserObject(), processInstance, processInstanceId)) {
            throw new NotFoundException("Process with id: " + processInstanceId + " does not exist or is not available for this user");
        }
        return this.runtimeService.getStartFormModel(processInstance.getProcessDefinitionId(), processInstance.getId());
    }

    public ProcessInstanceRepresentation startNewProcessInstance(CreateProcessInstanceRepresentation startRequest) {
        UserCache.CachedUser cachedUser;
        if (StringUtils.isEmpty((CharSequence)startRequest.getProcessDefinitionId())) {
            throw new BadRequestException("Process definition id is required");
        }
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(startRequest.getProcessDefinitionId());
        if (!this.permissionService.canStartProcess(SecurityUtils.getCurrentUserObject(), processDefinition)) {
            throw new NotPermittedException("User is not listed as potential starter for process definition with id: " + processDefinition.getId());
        }
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceWithForm(startRequest.getProcessDefinitionId(), startRequest.getOutcome(), startRequest.getValues(), startRequest.getName());
        User user = null;
        if (processInstance.getStartUserId() != null && (cachedUser = this.userCache.getUser(processInstance.getStartUserId())) != null && cachedUser.getUser() != null) {
            user = cachedUser.getUser();
        }
        return new ProcessInstanceRepresentation(processInstance, processDefinition, ((ProcessDefinitionEntity)processDefinition).isGraphicalNotationDefined(), user);
    }

    public void deleteProcessInstance(String processInstanceId) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).startedBy(String.valueOf(currentUser.getId())).singleResult();
        if (processInstance == null) {
            throw new NotFoundException("Process with id: " + processInstanceId + " does not exist or is not started by this user");
        }
        if (processInstance.getEndTime() != null) {
            if (!this.permissionService.canDeleteProcessInstance(currentUser, processInstance)) {
                throw new NotFoundException("Process with id: " + processInstanceId + " is already completed and can't be deleted");
            }
            this.contentService.deleteContentItemsByProcessInstanceId(processInstanceId);
            this.commentService.deleteAllCommentsForProcessInstance(processInstanceId);
            this.historyService.deleteHistoricProcessInstance(processInstanceId);
        } else {
            this.runtimeService.deleteProcessInstance(processInstanceId, "Cancelled by " + SecurityUtils.getCurrentUserId());
        }
    }
}

