/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.idm;

import javax.servlet.http.HttpServletResponse;
import org.flowable.idm.api.User;
import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class UserResource {
    @Autowired
    protected RemoteIdmService remoteIdmService;

    @GetMapping(value={"/rest/users/{userId}"}, produces={"application/json"})
    public UserRepresentation getUser(@PathVariable String userId, HttpServletResponse response) {
        RemoteUser user = this.remoteIdmService.getUser(userId);
        if (user == null) {
            throw new NotFoundException("User with id: " + userId + " does not exist or is inactive");
        }
        return new UserRepresentation((User)user);
    }
}

