/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.idm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.idm.api.User;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class WorkflowUsersResource {
    @Autowired
    private RemoteIdmService remoteIdmService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;

    @GetMapping(value={"/rest/workflow-users"})
    public ResultListDataRepresentation getUsers(@RequestParam(value="filter", required=false) String filter, @RequestParam(value="excludeTaskId", required=false) String excludeTaskId, @RequestParam(value="excludeProcessId", required=false) String excludeProcessId) {
        List matchingUsers = this.remoteIdmService.findUsersByNameFilter(filter);
        if (excludeTaskId != null) {
            this.filterUsersInvolvedInTask(excludeTaskId, matchingUsers);
        } else if (excludeProcessId != null) {
            this.filterUsersInvolvedInProcess(excludeProcessId, matchingUsers);
        }
        ArrayList<UserRepresentation> userRepresentations = new ArrayList<UserRepresentation>(matchingUsers.size());
        for (User user : matchingUsers) {
            userRepresentations.add(new UserRepresentation(user));
        }
        return new ResultListDataRepresentation(userRepresentations);
    }

    protected void filterUsersInvolvedInProcess(String excludeProcessId, List<? extends User> matchingUsers) {
        Set<String> involvedUsers = this.getInvolvedUsersAsSet(this.runtimeService.getIdentityLinksForProcessInstance(excludeProcessId));
        this.removeinvolvedUsers(matchingUsers, involvedUsers);
    }

    protected void filterUsersInvolvedInTask(String excludeTaskId, List<? extends User> matchingUsers) {
        Set<String> involvedUsers = this.getInvolvedUsersAsSet(this.taskService.getIdentityLinksForTask(excludeTaskId));
        this.removeinvolvedUsers(matchingUsers, involvedUsers);
    }

    protected Set<String> getInvolvedUsersAsSet(List<IdentityLink> involvedPeople) {
        HashSet<String> involved = null;
        if (involvedPeople.size() > 0) {
            involved = new HashSet<String>();
            for (IdentityLink link : involvedPeople) {
                if (link.getUserId() == null) continue;
                involved.add(link.getUserId());
            }
        }
        return involved;
    }

    protected void removeinvolvedUsers(List<? extends User> matchingUsers, Set<String> involvedUsers) {
        if (involvedUsers != null) {
            Iterator<? extends User> userIt = matchingUsers.iterator();
            while (userIt.hasNext()) {
                if (!involvedUsers.contains(userIt.next().getId())) continue;
                userIt.remove();
            }
        }
    }
}

