/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonType
implements VariableType {
    public static final String TYPE_NAME = "json";
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonType.class);
    protected final int maxLength;
    protected ObjectMapper objectMapper;

    public JsonType(int maxLength, ObjectMapper objectMapper) {
        this.maxLength = maxLength;
        this.objectMapper = objectMapper;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        JsonNode jsonValue = null;
        if (valueFields.getTextValue() != null && valueFields.getTextValue().length() > 0) {
            try {
                jsonValue = this.objectMapper.readTree(valueFields.getTextValue());
            }
            catch (Exception e) {
                LOGGER.error("Error reading json variable {}", (Object)valueFields.getName(), (Object)e);
            }
        }
        return jsonValue;
    }

    public void setValue(Object value, ValueFields valueFields) {
        valueFields.setTextValue(value != null ? value.toString() : null);
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (JsonNode.class.isAssignableFrom(value.getClass())) {
            JsonNode jsonValue = (JsonNode)value;
            return jsonValue.toString().length() <= this.maxLength;
        }
        return false;
    }
}

