/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.logging.console;

import org.flywaydb.core.internal.util.logging.Log;

public class ConsoleLog
implements Log {
    private final Level level;

    public ConsoleLog(Level level) {
        this.level = level;
    }

    @Override
    public void debug(String message) {
        if (this.level == Level.DEBUG) {
            System.out.println("DEBUG: " + message);
        }
    }

    @Override
    public void info(String message) {
        if (this.level.compareTo(Level.INFO) <= 0) {
            System.out.println(message);
        }
    }

    @Override
    public void warn(String message) {
        System.out.println("WARNING: " + message);
    }

    @Override
    public void error(String message) {
        System.err.println("ERROR: " + message);
    }

    @Override
    public void error(String message, Exception e) {
        System.err.println("ERROR: " + message);
        e.printStackTrace(System.err);
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN;

    }
}

