/*
 * Decompiled with CFR 0.152.
 */
package io.fury.builder;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.builder.Generated;
import io.fury.builder.ObjectCodecBuilder;
import io.fury.builder.ObjectCodecOptimizer;
import io.fury.codegen.CodeGenerator;
import io.fury.codegen.Expression;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.CodegenSerializer;
import io.fury.serializer.MetaSharedSerializer;
import io.fury.serializer.ObjectSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.type.ClassDef;
import io.fury.type.Descriptor;
import io.fury.type.DescriptorGrouper;
import io.fury.util.StringUtils;
import io.fury.util.Utils;
import io.fury.util.record.RecordComponent;
import io.fury.util.record.RecordUtils;
import java.util.Collection;
import java.util.SortedMap;

public class MetaSharedCodecBuilder
extends ObjectCodecBuilder {
    private final ClassDef classDef;

    public MetaSharedCodecBuilder(TypeToken<?> beanType, Fury fury, ClassDef classDef) {
        super(beanType, fury, Generated.GeneratedMetaSharedSerializer.class);
        Preconditions.checkArgument((!fury.getConfig().checkClassVersion() ? 1 : 0) != 0, (Object)"Class version check should be disabled when compatible mode is enabled.");
        this.classDef = classDef;
        Collection descriptors = this.visitFury(f -> MetaSharedSerializer.consolidateFields(f.getClassResolver(), this.beanClass, classDef));
        DescriptorGrouper grouper = DescriptorGrouper.createDescriptorGrouper(descriptors, true, fury.compressInt(), fury.compressLong());
        this.objectCodecOptimizer = new ObjectCodecOptimizer(this.beanClass, grouper, !fury.isBasicTypesRefIgnored(), this.ctx);
    }

    @Override
    protected String codecSuffix() {
        return "MetaShared" + this.classDef.getId();
    }

    @Override
    public String genCode() {
        this.ctx.setPackage(CodeGenerator.getPackage(this.beanClass));
        String className = this.codecClassName(this.beanClass);
        this.ctx.setClassName(className);
        this.ctx.extendsClasses(this.ctx.type(this.parentSerializerClass));
        this.ctx.reserveName("classType");
        this.ctx.reserveName("serializer");
        this.ctx.addField(this.ctx.type(Fury.class), "fury");
        String constructorCode = StringUtils.format("super(${fury}, ${cls});\nthis.${fury} = ${fury};\n${serializer} = ${builderClass}.setCodegenSerializer(${fury}, ${cls}, this);\n", "fury", "fury", "cls", "classType", "builderClass", MetaSharedCodecBuilder.class.getName(), "serializer", "serializer");
        this.ctx.clearExprState();
        Expression decodeExpr = this.buildDecodeExpression();
        String decodeCode = decodeExpr.genCode(this.ctx).code();
        decodeCode = this.ctx.optimizeMethodCode(decodeCode);
        this.ctx.overrideMethod("read", decodeCode, Object.class, MemoryBuffer.class, "buffer");
        this.registerJITNotifyCallback();
        this.ctx.addConstructor(constructorCode, Fury.class, "fury", Class.class, "classType");
        return this.ctx.genCode();
    }

    @Override
    protected void addCommonImports() {
        super.addCommonImports();
        this.ctx.addImport(Generated.GeneratedMetaSharedSerializer.class);
    }

    public static Serializer setCodegenSerializer(Fury fury, Class<?> cls, Generated.GeneratedMetaSharedSerializer s) {
        Class serializerClass = fury.getJITContext().registerSerializerJITCallback(() -> ObjectSerializer.class, () -> CodegenSerializer.loadCodegenSerializer(fury, s.getType()), c -> {
            s.serializer = Serializers.newSerializer(fury, s.getType(), c);
        });
        return Serializers.newSerializer(fury, cls, serializerClass);
    }

    @Override
    public Expression buildEncodeExpression() {
        throw new IllegalStateException("unreachable");
    }

    @Override
    protected Expression buildComponentsArray() {
        return this.buildDefaultComponentsArray();
    }

    @Override
    protected Expression createRecord(SortedMap<Integer, Expression> recordComponents) {
        RecordComponent[] components = RecordUtils.getRecordComponents(this.beanClass);
        Object[] defaultValues = RecordUtils.buildRecordComponentDefaultValues(this.beanClass);
        for (int i = 0; i < defaultValues.length; ++i) {
            if (recordComponents.containsKey(i)) continue;
            Object defaultValue = defaultValues[i];
            assert (components != null);
            RecordComponent component = components[i];
            recordComponents.put(i, new Expression.Literal(defaultValue, TypeToken.of(component.getType())));
        }
        Expression[] params = recordComponents.values().toArray(new Expression[0]);
        return new Expression.NewInstance(this.beanType, params);
    }

    @Override
    protected Expression setFieldValue(Expression bean, Descriptor descriptor, Expression value) {
        if (descriptor.getField() == null) {
            return new Expression.StaticInvoke(Utils.class, "ignore", value);
        }
        return super.setFieldValue(bean, descriptor, value);
    }
}

