/*
 * Decompiled with CFR 0.152.
 */
package io.fury.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import io.fury.codegen.Code;
import io.fury.codegen.CodeGenerator;
import io.fury.codegen.ExprState;
import io.fury.codegen.Expression;
import io.fury.collection.Tuple2;
import io.fury.collection.Tuple3;
import io.fury.type.TypeUtils;
import io.fury.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CodegenContext {
    public static Set<String> JAVA_RESERVED_WORDS = new HashSet<String>();
    Map<String, Long> newValNameIds = new HashMap<String, Long>();
    Set<String> valNames = new HashSet<String>();
    Map<Expression, ExprState> exprState = new HashMap<Expression, ExprState>();
    String pkg;
    LinkedHashSet<String> imports = new LinkedHashSet();
    String className;
    String[] superClasses;
    String[] interfaces;
    List<Tuple3<Boolean, String, String>> fields = new ArrayList<Tuple3<Boolean, String, String>>();
    List<String> initCodes = new ArrayList<String>();
    List<String> constructors = new ArrayList<String>();
    LinkedHashMap<String, String> methods = new LinkedHashMap();
    private CodegenContext instanceInitCtx;

    public CodegenContext() {
    }

    public CodegenContext(LinkedHashSet<String> imports) {
        this.imports = imports;
    }

    public CodegenContext(Set<String> valNames, LinkedHashSet<String> imports) {
        this.valNames = valNames;
        this.imports = imports;
    }

    public void reserveName(String name) {
        Preconditions.checkArgument((!this.valNames.contains(name) ? 1 : 0) != 0);
        String s = this.newName(name);
        Preconditions.checkArgument((boolean)s.equals(name));
    }

    public boolean containName(String name) {
        return this.valNames.contains(name);
    }

    public String newName(Class<?> clz) {
        return this.newName(this.namePrefix(clz));
    }

    public String newName(Class<?> clz, String suffix) {
        String name = this.newName(clz);
        return this.newName(name + suffix);
    }

    public String newName(String name) {
        this.newValNameIds.putIfAbsent(name, 0L);
        long id = this.newValNameIds.get(name);
        this.newValNameIds.put(name, id + 1L);
        if (id == 0L && this.valNames.add(name)) {
            return name;
        }
        String newName = String.format("%s%s", name, id);
        while (this.valNames.contains(newName)) {
            this.newValNameIds.put(name, ++id);
            newName = String.format("%s%s", name, id);
        }
        this.valNames.add(newName);
        return newName;
    }

    public String[] newNames(Class<?> clz1, String name2) {
        if (clz1.isArray()) {
            return this.newNames("arr", name2);
        }
        String type = this.type(clz1);
        int index = type.lastIndexOf(".");
        String name = index >= 0 ? StringUtils.uncapitalize(type.substring(index + 1)) : StringUtils.uncapitalize(type);
        if (JAVA_RESERVED_WORDS.contains(name)) {
            return this.newNames("value", name2);
        }
        return this.newNames(name, name2);
    }

    public String[] newNames(String ... names) {
        long id = 0L;
        for (String name : names) {
            id = Math.max(id, this.newValNameIds.getOrDefault(name, 0L));
        }
        for (String name : names) {
            this.newValNameIds.put(name, id + 1L);
        }
        if (id == 0L && Sets.intersection(this.valNames, (Set)Sets.newHashSet((Object[])names)).isEmpty()) {
            this.valNames.addAll(Arrays.asList(names));
            return names;
        }
        String[] newNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            newNames[i] = String.format("%s%s", names[i], id);
            while (this.valNames.contains(newNames[i])) {
                this.newValNameIds.put(newNames[i], ++id);
                newNames[i] = String.format("%s%s", names[i], id);
            }
        }
        this.valNames.addAll(Arrays.asList(newNames));
        return newNames;
    }

    public String namePrefix(Class<?> clz) {
        if (clz.isArray()) {
            return "arr";
        }
        String type = this.type(clz);
        int index = type.lastIndexOf(".");
        String name = index >= 0 ? StringUtils.uncapitalize(type.substring(index + 1)) : StringUtils.uncapitalize(type);
        if (JAVA_RESERVED_WORDS.contains(name)) {
            return "value";
        }
        return name;
    }

    public String type(Class<?> clz) {
        String pkgOrClassName;
        if (clz.isArray()) {
            return TypeUtils.getArrayType(clz);
        }
        String type = clz.getCanonicalName();
        if (type.startsWith("java.lang") && !type.substring("java.lang.".length()).contains(".")) {
            return clz.getSimpleName();
        }
        if (this.imports.contains(type)) {
            return clz.getSimpleName();
        }
        int index = type.lastIndexOf(".");
        if (index > 0 && this.imports.contains((pkgOrClassName = type.substring(0, index)) + ".*")) {
            return clz.getSimpleName();
        }
        return type;
    }

    public String type(TypeToken<?> typeToken) {
        return this.type(TypeUtils.getRawType(typeToken));
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }

    public Set<String> getValNames() {
        return this.valNames;
    }

    public LinkedHashSet<String> getImports() {
        return this.imports;
    }

    public void addImports(Class<?> ... classes) {
        for (Class<?> clz : classes) {
            this.imports.add(clz.getCanonicalName());
        }
    }

    public void addImports(String ... imports) {
        this.imports.addAll(Arrays.asList(imports));
    }

    public void addImport(Class<?> cls) {
        this.imports.add(cls.getCanonicalName());
    }

    public void addImport(String im) {
        this.imports.add(im);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void extendsClasses(String ... superClasses) {
        this.superClasses = superClasses;
    }

    public void implementsInterfaces(String ... interfaces) {
        this.interfaces = interfaces;
    }

    public void addConstructor(String codeBody, Object ... params) {
        List<Tuple2<String, String>> parameters = this.getParameters(params);
        String paramsStr = parameters.stream().map(t -> (String)t.f0 + " " + (String)t.f1).collect(Collectors.joining(", "));
        StringBuilder codeBuilder = new StringBuilder(CodeGenerator.alignIndent(codeBody)).append("\n");
        for (String init : this.initCodes) {
            codeBuilder.append(CodeGenerator.indent(init, 4)).append('\n');
        }
        String constructor = StringUtils.format("public ${className}(${paramsStr}) {\n    ${codeBody}}", "className", this.className, "paramsStr", paramsStr, "codeBody", codeBuilder);
        this.constructors.add(constructor);
    }

    public void addInitCode(String code) {
        this.initCodes.add(code);
    }

    public void addStaticMethod(String methodName, String codeBody, Class<?> returnType, Object ... params) {
        this.addMethod("public static", methodName, codeBody, returnType, params);
    }

    public void addMethod(String methodName, String codeBody, Class<?> returnType, Object ... params) {
        this.addMethod("public", methodName, codeBody, returnType, params);
    }

    public void addMethod(String modifier, String methodName, String codeBody, Class<?> returnType, Object ... params) {
        List<Tuple2<String, String>> parameters = this.getParameters(params);
        String paramsStr = parameters.stream().map(t -> (String)t.f0 + " " + (String)t.f1).collect(Collectors.joining(", "));
        String method = StringUtils.format("${modifier} ${returnType} ${methodName}(${paramsStr}) {\n    ${codeBody}\n}\n", "modifier", modifier, "returnType", this.type(returnType), "methodName", methodName, "paramsStr", paramsStr, "codeBody", CodeGenerator.alignIndent(codeBody));
        String signature = String.format("%s(%s)", methodName, paramsStr);
        if (this.methods.containsKey(signature)) {
            throw new IllegalStateException(String.format("Duplicated method signature: %s", signature));
        }
        this.methods.put(signature, method);
    }

    public void overrideMethod(String methodName, String codeBody, Class<?> returnType, Object ... params) {
        this.addMethod("@Override public final", methodName, codeBody, returnType, params);
    }

    private List<Tuple2<String, String>> getParameters(Object ... args) {
        Preconditions.checkArgument((args.length % 2 == 0 ? 1 : 0) != 0);
        ArrayList<Tuple2<String, String>> params = new ArrayList<Tuple2<String, String>>(0);
        for (int i = 0; i < args.length; i += 2) {
            String type = args[i] instanceof Class ? this.type((Class)args[i]) : args[i].toString();
            params.add(Tuple2.of(type, args[i + 1].toString()));
        }
        return params;
    }

    public boolean hasField(String fieldName) {
        for (Tuple3<Boolean, String, String> field : this.fields) {
            if (!fieldName.equals(field.f2)) continue;
            return true;
        }
        return false;
    }

    public void addField(Class<?> type, String fieldName, Expression initExpr) {
        this.addField(this.type(type), fieldName, initExpr);
    }

    public void addField(String type, String fieldName, Expression initExpr) {
        this.addField(type, fieldName, initExpr, true);
    }

    public void addField(String type, String fieldName, Expression initExpr, boolean isFinalField) {
        if (this.instanceInitCtx == null) {
            this.instanceInitCtx = new CodegenContext(this.valNames, this.imports);
        }
        this.fields.add(Tuple3.of(isFinalField, type, fieldName));
        Code.ExprCode exprCode = initExpr.genCode(this.instanceInitCtx);
        if (StringUtils.isNotBlank(exprCode.code())) {
            this.initCodes.add(exprCode.code());
        }
        this.initCodes.add(String.format("%s = %s;", fieldName, exprCode.value()));
    }

    public void addField(String type, String fieldName, String initCode) {
        this.fields.add(Tuple3.of(false, type, fieldName));
        if (StringUtils.isNotBlank(initCode)) {
            this.initCodes.add(initCode);
        }
    }

    public void addField(Class<?> type, String fieldName) {
        this.addField(this.type(type), fieldName);
    }

    public void addField(String type, String fieldName) {
        this.fields.add(Tuple3.of(true, type, fieldName));
    }

    public String genCode() {
        StringBuilder codeBuilder = new StringBuilder();
        if (StringUtils.isNotBlank(this.pkg)) {
            codeBuilder.append("package ").append(this.pkg).append(";\n\n");
        }
        if (!this.imports.isEmpty()) {
            this.imports.forEach(clz -> codeBuilder.append("import ").append((String)clz).append(";\n"));
            codeBuilder.append('\n');
        }
        codeBuilder.append(String.format("public final class %s ", this.className));
        if (this.superClasses != null) {
            codeBuilder.append(String.format("extends %s ", String.join((CharSequence)", ", this.superClasses)));
        }
        if (this.interfaces != null) {
            codeBuilder.append(String.format("implements %s ", String.join((CharSequence)", ", this.interfaces)));
        }
        codeBuilder.append("{\n");
        if (!this.fields.isEmpty()) {
            codeBuilder.append('\n');
            for (Tuple3<Boolean, String, String> field : this.fields) {
                String declare = (Boolean)field.f0 != false ? String.format("private final %s %s;\n", field.f1, field.f2) : String.format("private %s %s;\n", field.f1, field.f2);
                codeBuilder.append(CodeGenerator.indent(declare));
            }
        }
        if (!this.constructors.isEmpty()) {
            codeBuilder.append('\n');
            this.constructors.forEach(constructor -> codeBuilder.append(CodeGenerator.indent(constructor)).append('\n'));
        }
        codeBuilder.append('\n');
        this.methods.values().forEach(method -> codeBuilder.append(CodeGenerator.indent(method)).append('\n'));
        codeBuilder.append('}');
        return codeBuilder.toString();
    }

    public void clearExprState() {
        this.exprState.clear();
    }

    public String optimizeMethodCode(String code) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Expression, ExprState> entry : this.exprState.entrySet()) {
            Expression.Reference reference;
            Expression expression = entry.getKey();
            ExprState value = entry.getValue();
            if (!(expression instanceof Expression.Reference) || !(reference = (Expression.Reference)expression).isFieldRef() || value.getAccessCount() <= 1) continue;
            String type = this.type(reference.type());
            String cacheVariable = StringUtils.format("${type} ${name} = this.${name};", "type", type, "name", reference.name());
            builder.append(cacheVariable).append('\n');
        }
        if (builder.length() > 0) {
            return builder.append(code).toString();
        }
        return code;
    }

    static {
        JAVA_RESERVED_WORDS.addAll(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null"));
        JAVA_RESERVED_WORDS = ImmutableSet.copyOf(JAVA_RESERVED_WORDS);
    }
}

