/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.AbstractEpic;
import org.gitlab4j.api.utils.ISO8601;
import org.gitlab4j.api.utils.JacksonJsonEnumHelper;

public class EpicFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long authorId;
    private String authorUsername;
    private String labels;
    private Constants.EpicOrderBy orderBy;
    private Constants.SortOrder sort;
    private String search;
    private AbstractEpic.EpicState state;
    private Date createdAfter;
    private Date updatedAfter;
    private Date updatedBefore;
    private Boolean includeAncestorGroups;
    private Boolean includeDescendantGroups;
    private String myReactionEmoji;
    private Map<EpicField, Object> not;

    public EpicFilter withAuthorId(Long authorId) {
        this.authorId = authorId;
        return this;
    }

    public EpicFilter withAuthorUsername(String authorUsername) {
        this.authorUsername = authorUsername;
        return this;
    }

    public EpicFilter withLabels(String labels) {
        this.labels = labels;
        return this;
    }

    public EpicFilter withOrderBy(Constants.EpicOrderBy orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public EpicFilter withSortOrder(Constants.SortOrder sort) {
        this.sort = sort;
        return this;
    }

    public EpicFilter withSearch(String search) {
        this.search = search;
        return this;
    }

    public EpicFilter withState(AbstractEpic.EpicState state) {
        this.state = state;
        return this;
    }

    public EpicFilter withCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    public EpicFilter withUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
        return this;
    }

    public EpicFilter withUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore;
        return this;
    }

    public EpicFilter withIncludeAncestorGroups(Boolean includeAncestorGroups) {
        this.includeAncestorGroups = includeAncestorGroups;
        return this;
    }

    public EpicFilter withIncludeDescendantGroups(Boolean includeDescendantGroups) {
        this.includeDescendantGroups = includeDescendantGroups;
        return this;
    }

    public EpicFilter withMyReactionEmoji(String myReactionEmoji) {
        this.myReactionEmoji = myReactionEmoji;
        return this;
    }

    public EpicFilter withNot(Map<EpicField, Object> not) {
        this.not = not;
        return this;
    }

    public EpicFilter withoutAuthorId(Long authorId) {
        return this.withNot(EpicField.AUTHOR_ID, authorId);
    }

    public EpicFilter withoutAuthorUsername(String authorUsername) {
        return this.withNot(EpicField.AUTHOR_USERNAME, authorUsername);
    }

    public EpicFilter withoutLabels(String ... labels) {
        return this.withNot(EpicField.LABELS, String.join((CharSequence)",", labels));
    }

    public EpicFilter withNot(EpicField field, Object value) {
        if (this.not == null) {
            this.not = new LinkedHashMap<EpicField, Object>();
        }
        this.not.put(field, value);
        return this;
    }

    public GitLabApiForm getQueryParams() {
        return new GitLabApiForm().withParam("author_id", this.authorId).withParam("author_username", this.authorUsername).withParam("labels", this.labels).withParam("order_by", (Object)this.orderBy).withParam("sort", (Object)this.sort).withParam("search", this.search).withParam("state", (Object)this.state).withParam("created_after", ISO8601.toString(this.createdAfter, false)).withParam("updated_after", ISO8601.toString(this.updatedAfter, false)).withParam("updated_before", ISO8601.toString(this.updatedBefore, false)).withParam("include_ancestor_groups", this.includeAncestorGroups).withParam("include_descendant_groups", this.includeDescendantGroups).withParam("my_reaction_emoji", this.myReactionEmoji).withParam("not", this.toStringMap(this.not), false);
    }

    private Map<String, Object> toStringMap(Map<EpicField, Object> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<EpicField, Object> entry : map.entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue());
        }
        return result;
    }

    public static enum EpicField {
        AUTHOR_ID,
        AUTHOR_USERNAME,
        LABELS;

        private static JacksonJsonEnumHelper<EpicField> enumHelper;

        @JsonCreator
        public static EpicField forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<EpicField>(EpicField.class);
        }
    }
}

