// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.MethodHandles;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link HasHiddenKeyCacheNode#doCached}
 *     Activation probability: 0.48333
 *     With/without class size: 16/9 bytes
 *   Specialization {@link HasHiddenKeyCacheNode#doUncached}
 *     Activation probability: 0.33333
 *     With/without class size: 8/0 bytes
 *   Specialization {@link HasHiddenKeyCacheNode#doNonObject}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(HasHiddenKeyCacheNode.class)
@SuppressWarnings("javadoc")
public final class HasHiddenKeyCacheNodeGen extends HasHiddenKeyCacheNode {

    static final ReferenceField<CachedData> CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link HasHiddenKeyCacheNode#doCached}
     *   1: SpecializationActive {@link HasHiddenKeyCacheNode#doUncached}
     *   2: SpecializationActive {@link HasHiddenKeyCacheNode#doNonObject}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @CompilationFinal private CachedData cached_cache;

    private HasHiddenKeyCacheNodeGen(HiddenKey key) {
        super(key);
    }

    @ExplodeLoop
    @Override
    public boolean executeHasHiddenKey(Object arg0Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0 /* is SpecializationActive[HasHiddenKeyCacheNode.doCached(JSDynamicObject, Shape, boolean, int)] || SpecializationActive[HasHiddenKeyCacheNode.doUncached(JSDynamicObject)] || SpecializationActive[HasHiddenKeyCacheNode.doNonObject(Object)] */) {
            if ((state_0 & 0b11) != 0 /* is SpecializationActive[HasHiddenKeyCacheNode.doCached(JSDynamicObject, Shape, boolean, int)] || SpecializationActive[HasHiddenKeyCacheNode.doUncached(JSDynamicObject)] */ && arg0Value instanceof JSDynamicObject) {
                JSDynamicObject arg0Value_ = (JSDynamicObject) arg0Value;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[HasHiddenKeyCacheNode.doCached(JSDynamicObject, Shape, boolean, int)] */) {
                    CachedData s0_ = this.cached_cache;
                    while (s0_ != null) {
                        if (!Assumption.isValidAssumption(s0_.assumption0_)) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            removeCached_(s0_);
                            return executeAndSpecialize(arg0Value_);
                        }
                        if ((s0_.cachedShape_.check(arg0Value_))) {
                            return HasHiddenKeyCacheNode.doCached(arg0Value_, s0_.cachedShape_, s0_.hasOwnProperty_, s0_.cacheLimit_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[HasHiddenKeyCacheNode.doUncached(JSDynamicObject)] */) {
                    if ((JSGuards.isJSObject(arg0Value_))) {
                        return doUncached(arg0Value_);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[HasHiddenKeyCacheNode.doNonObject(Object)] */) {
                if ((!(JSGuards.isJSObject(arg0Value)))) {
                    return HasHiddenKeyCacheNode.doNonObject(arg0Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("unused")
    private boolean executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof JSDynamicObject) {
            JSDynamicObject arg0Value_ = (JSDynamicObject) arg0Value;
            if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[HasHiddenKeyCacheNode.doUncached(JSDynamicObject)] */) {
                while (true) {
                    int count0_ = 0;
                    CachedData s0_ = CACHED_CACHE_UPDATER.getVolatile(this);
                    CachedData s0_original = s0_;
                    while (s0_ != null) {
                        if ((s0_.cachedShape_.check(arg0Value_)) && Assumption.isValidAssumption(s0_.assumption0_)) {
                            break;
                        }
                        count0_++;
                        s0_ = s0_.next_;
                    }
                    if (s0_ == null) {
                        {
                            Shape cachedShape__ = (arg0Value_.getShape());
                            if ((cachedShape__.check(arg0Value_))) {
                                Assumption assumption0 = (cachedShape__.getValidAssumption());
                                if (Assumption.isValidAssumption(assumption0)) {
                                    int cacheLimit__ = (getPropertyCacheLimit());
                                    if (count0_ < (cacheLimit__)) {
                                        s0_ = new CachedData(s0_original);
                                        Objects.requireNonNull(cachedShape__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s0_.cachedShape_ = cachedShape__;
                                        s0_.hasOwnProperty_ = (doUncached(arg0Value_));
                                        s0_.cacheLimit_ = cacheLimit__;
                                        s0_.assumption0_ = assumption0;
                                        if (!CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b1 /* add SpecializationActive[HasHiddenKeyCacheNode.doCached(JSDynamicObject, Shape, boolean, int)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                        }
                    }
                    if (s0_ != null) {
                        return HasHiddenKeyCacheNode.doCached(arg0Value_, s0_.cachedShape_, s0_.hasOwnProperty_, s0_.cacheLimit_);
                    }
                    break;
                }
            }
            if ((JSGuards.isJSObject(arg0Value_))) {
                this.cached_cache = null;
                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[HasHiddenKeyCacheNode.doCached(JSDynamicObject, Shape, boolean, int)] */;
                state_0 = state_0 | 0b10 /* add SpecializationActive[HasHiddenKeyCacheNode.doUncached(JSDynamicObject)] */;
                this.state_0_ = state_0;
                return doUncached(arg0Value_);
            }
        }
        if ((!(JSGuards.isJSObject(arg0Value)))) {
            state_0 = state_0 | 0b100 /* add SpecializationActive[HasHiddenKeyCacheNode.doNonObject(Object)] */;
            this.state_0_ = state_0;
            return HasHiddenKeyCacheNode.doNonObject(arg0Value);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value);
    }

    void removeCached_(CachedData s0_) {
        while (true) {
            CachedData cur = this.cached_cache;
            CachedData original = cur;
            CachedData update = null;
            while (cur != null) {
                if (cur == s0_) {
                    if (cur == original) {
                        update = cur.next_;
                    } else {
                        update = original.remove(s0_);
                    }
                    break;
                }
                cur = cur.next_;
            }
            if (cur != null && !CACHED_CACHE_UPDATER.compareAndSet(this, original, update)) {
                continue;
            }
            break;
        }
    }

    @NeverDefault
    public static HasHiddenKeyCacheNode create(HiddenKey key) {
        return new HasHiddenKeyCacheNodeGen(key);
    }

    @GeneratedBy(HasHiddenKeyCacheNode.class)
    @DenyReplace
    private static final class CachedData implements SpecializationDataNode {

        @CompilationFinal final CachedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HasHiddenKeyCacheNode#doCached}
         *   Parameter: {@link Shape} cachedShape</pre>
         */
        @CompilationFinal Shape cachedShape_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HasHiddenKeyCacheNode#doCached}
         *   Parameter: boolean hasOwnProperty</pre>
         */
        @CompilationFinal boolean hasOwnProperty_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link HasHiddenKeyCacheNode#doCached}
         *   Parameter: int cacheLimit</pre>
         */
        @CompilationFinal int cacheLimit_;
        @CompilationFinal Assumption assumption0_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        CachedData remove(CachedData search) {
            CachedData newNext = this.next_;
            if (newNext != null) {
                if (search == newNext) {
                    newNext = newNext.next_;
                } else {
                    newNext = newNext.remove(search);
                }
            }
            CachedData copy = new CachedData(newNext);
            copy.cachedShape_ = this.cachedShape_;
            copy.hasOwnProperty_ = this.hasOwnProperty_;
            copy.cacheLimit_ = this.cacheLimit_;
            copy.assumption0_ = this.assumption0_;
            return copy;
        }

    }
}
