// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.runtime.SafeInteger;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSWriteCurrentFrameSlotNode#doBoolean}
 *     Activation probability: 0.27381
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSWriteCurrentFrameSlotNode#doInteger}
 *     Activation probability: 0.23095
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSWriteCurrentFrameSlotNode#doSafeInteger}
 *     Activation probability: 0.18810
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSWriteCurrentFrameSlotNode#doLong}
 *     Activation probability: 0.14524
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSWriteCurrentFrameSlotNode#doDouble}
 *     Activation probability: 0.10238
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSWriteCurrentFrameSlotNode#doObject}
 *     Activation probability: 0.05952
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(JSWriteCurrentFrameSlotNode.class)
@SuppressWarnings("javadoc")
final class JSWriteCurrentFrameSlotNodeGen extends JSWriteCurrentFrameSlotNode {

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSWriteCurrentFrameSlotNode#doBoolean}
     *   1: SpecializationActive {@link JSWriteCurrentFrameSlotNode#doObject}
     *   2: SpecializationActive {@link JSWriteCurrentFrameSlotNode#doInteger}
     *   3: SpecializationActive {@link JSWriteCurrentFrameSlotNode#doDouble}
     *   4: SpecializationActive {@link JSWriteCurrentFrameSlotNode#doSafeInteger}
     *   5: SpecializationActive {@link JSWriteCurrentFrameSlotNode#doLong}
     *   6-8: ImplicitCast[type=double, index=0]
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private JSWriteCurrentFrameSlotNodeGen(int slot, Object identifier, JavaScriptNode rhsNode) {
        super(slot, identifier, rhsNode);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111110) == 0 /* only-active SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */)) {
            return execute_boolean0(state_0, frameValue);
        } else if ((state_0 & 0b111011) == 0 /* only-active SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */)) {
            return execute_int1(state_0, frameValue);
        } else if ((state_0 & 0b110111) == 0 /* only-active SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */)) {
            return execute_double2(state_0, frameValue);
        } else {
            return execute_generic3(state_0, frameValue);
        }
    }

    private Object execute_boolean0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        boolean rhsNodeValue_;
        try {
            rhsNodeValue_ = super.rhsNode.executeBoolean(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] */;
        if ((isBooleanKind(frameValue))) {
            return doBoolean(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, rhsNodeValue_);
    }

    private Object execute_int1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int rhsNodeValue_;
        try {
            rhsNodeValue_ = super.rhsNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, ex.getResult());
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] */;
        {
            FrameSlotKind kind__ = (getFrameDescriptor(frameValue).getSlotKind(slot));
            if ((isIntegerKind(frameValue, kind__) || isLongKind(frameValue, kind__) || isDoubleKind(frameValue, kind__))) {
                return doInteger(frameValue, rhsNodeValue_, kind__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, rhsNodeValue_);
    }

    private Object execute_double2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int rhsNodeValue_int = 0;
        double rhsNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */)) {
                rhsNodeValue_ = super.rhsNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */)) {
                rhsNodeValue_int = super.rhsNode.executeInt(frameValue);
                rhsNodeValue_ = JSTypes.intToDouble(rhsNodeValue_int);
            } else {
                Object rhsNodeValue__ = super.rhsNode.execute(frameValue);
                rhsNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, rhsNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, ex.getResult());
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] */;
        if ((isDoubleKind(frameValue))) {
            return doDouble(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */) ? (Object) rhsNodeValue_int : (Object) rhsNodeValue_));
    }

    private Object execute_generic3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object rhsNodeValue_ = super.rhsNode.execute(frameValue);
        if ((state_0 & 0b111111) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] || SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] || SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] || SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] || SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] || SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] */ && rhsNodeValue_ instanceof Boolean) {
                boolean rhsNodeValue__ = (boolean) rhsNodeValue_;
                if ((isBooleanKind(frameValue))) {
                    return doBoolean(frameValue, rhsNodeValue__);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] */ && rhsNodeValue_ instanceof Integer) {
                int rhsNodeValue__ = (int) rhsNodeValue_;
                {
                    FrameSlotKind kind__ = (getFrameDescriptor(frameValue).getSlotKind(slot));
                    if ((isIntegerKind(frameValue, kind__) || isLongKind(frameValue, kind__) || isDoubleKind(frameValue, kind__))) {
                        return doInteger(frameValue, rhsNodeValue__, kind__);
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] */ && rhsNodeValue_ instanceof SafeInteger) {
                SafeInteger rhsNodeValue__ = (SafeInteger) rhsNodeValue_;
                if ((isLongKind(frameValue))) {
                    return doSafeInteger(frameValue, rhsNodeValue__);
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] */ && rhsNodeValue_ instanceof Long) {
                long rhsNodeValue__ = (long) rhsNodeValue_;
                return doLong(frameValue, rhsNodeValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, rhsNodeValue_)) {
                double rhsNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, rhsNodeValue_);
                if ((isDoubleKind(frameValue))) {
                    return doDouble(frameValue, rhsNodeValue__);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */) {
                return doObject(frameValue, rhsNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, rhsNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */) {
            return JSTypesGen.expectBoolean(execute(frameValue));
        }
        boolean rhsNodeValue_;
        try {
            rhsNodeValue_ = super.rhsNode.executeBoolean(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectBoolean(executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] */) {
            if ((isBooleanKind(frameValue))) {
                return doBoolean(frameValue, rhsNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(executeAndSpecialize(frameValue, rhsNodeValue_));
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */) {
            return JSTypesGen.expectDouble(execute(frameValue));
        }
        int rhsNodeValue_int = 0;
        double rhsNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */)) {
                rhsNodeValue_ = super.rhsNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */)) {
                rhsNodeValue_int = super.rhsNode.executeInt(frameValue);
                rhsNodeValue_ = JSTypes.intToDouble(rhsNodeValue_int);
            } else {
                Object rhsNodeValue__ = super.rhsNode.execute(frameValue);
                rhsNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, rhsNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] */) {
            if ((isDoubleKind(frameValue))) {
                return doDouble(frameValue, rhsNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(executeAndSpecialize(frameValue, ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */) ? (Object) rhsNodeValue_int : (Object) rhsNodeValue_)));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */) {
            return JSTypesGen.expectInteger(execute(frameValue));
        }
        int rhsNodeValue_;
        try {
            rhsNodeValue_ = super.rhsNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] */) {
            {
                FrameSlotKind kind__ = (getFrameDescriptor(frameValue).getSlotKind(slot));
                if ((isIntegerKind(frameValue, kind__) || isLongKind(frameValue, kind__) || isDoubleKind(frameValue, kind__))) {
                    return doInteger(frameValue, rhsNodeValue_, kind__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(frameValue, rhsNodeValue_));
    }

    @Override
    void executeEvaluated(VirtualFrame frameValue, Object rhsNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111111) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] || SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] || SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] || SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] || SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] || SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] */ && rhsNodeValue instanceof Boolean) {
                boolean rhsNodeValue_ = (boolean) rhsNodeValue;
                if ((isBooleanKind(frameValue))) {
                    doBoolean(frameValue, rhsNodeValue_);
                    return;
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] */ && rhsNodeValue instanceof Integer) {
                int rhsNodeValue_ = (int) rhsNodeValue;
                {
                    FrameSlotKind kind__ = (getFrameDescriptor(frameValue).getSlotKind(slot));
                    if ((isIntegerKind(frameValue, kind__) || isLongKind(frameValue, kind__) || isDoubleKind(frameValue, kind__))) {
                        doInteger(frameValue, rhsNodeValue_, kind__);
                        return;
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] */ && rhsNodeValue instanceof SafeInteger) {
                SafeInteger rhsNodeValue_ = (SafeInteger) rhsNodeValue;
                if ((isLongKind(frameValue))) {
                    doSafeInteger(frameValue, rhsNodeValue_);
                    return;
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] */ && rhsNodeValue instanceof Long) {
                long rhsNodeValue_ = (long) rhsNodeValue;
                doLong(frameValue, rhsNodeValue_);
                return;
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, rhsNodeValue)) {
                double rhsNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=0] */, rhsNodeValue);
                if ((isDoubleKind(frameValue))) {
                    doDouble(frameValue, rhsNodeValue_);
                    return;
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */) {
                doObject(frameValue, rhsNodeValue);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(frameValue, rhsNodeValue);
        return;
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b111011) == 0 /* only-active SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */)) {
                executeInt(frameValue);
                return;
            } else if ((state_0 & 0b110111) == 0 /* only-active SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */)) {
                executeDouble(frameValue);
                return;
            } else if ((state_0 & 0b111110) == 0 /* only-active SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */)) {
                executeBoolean(frameValue);
                return;
            }
            execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object rhsNodeValue) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */ && rhsNodeValue instanceof Boolean) {
            boolean rhsNodeValue_ = (boolean) rhsNodeValue;
            if ((isBooleanKind(frameValue))) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)] */;
                this.state_0_ = state_0;
                return doBoolean(frameValue, rhsNodeValue_);
            }
        }
        {
            FrameSlotKind kind__ = null;
            if (((state_0 & 0b1010)) == 0 /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */ && rhsNodeValue instanceof Integer) {
                int rhsNodeValue_ = (int) rhsNodeValue;
                {
                    kind__ = (getFrameDescriptor(frameValue).getSlotKind(slot));
                    if ((isIntegerKind(frameValue, kind__) || isLongKind(frameValue, kind__) || isDoubleKind(frameValue, kind__))) {
                        state_0 = state_0 | 0b100 /* add SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)] */;
                        this.state_0_ = state_0;
                        return doInteger(frameValue, rhsNodeValue_, kind__);
                    }
                }
            }
        }
        if (((state_0 & 0b1010)) == 0 /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] && SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */ && rhsNodeValue instanceof SafeInteger) {
            SafeInteger rhsNodeValue_ = (SafeInteger) rhsNodeValue;
            if ((isLongKind(frameValue))) {
                state_0 = state_0 | 0b10000 /* add SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] */;
                this.state_0_ = state_0;
                return doSafeInteger(frameValue, rhsNodeValue_);
            }
        }
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */ && rhsNodeValue instanceof Long) {
            long rhsNodeValue_ = (long) rhsNodeValue;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)] */;
            this.state_0_ = state_0;
            return doLong(frameValue, rhsNodeValue_);
        }
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */) {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(rhsNodeValue)) != 0) {
                double rhsNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, rhsNodeValue);
                if ((isDoubleKind(frameValue))) {
                    state_0 = state_0 & 0xffffffeb /* remove SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)], SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)] */;
                    state_0 = (state_0 | (doubleCast0 << 6) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] */;
                    this.state_0_ = state_0;
                    return doDouble(frameValue, rhsNodeValue_);
                }
            }
        }
        state_0 = state_0 & 0xffffffc2 /* remove SpecializationActive[JSWriteCurrentFrameSlotNode.doBoolean(VirtualFrame, boolean)], SpecializationActive[JSWriteCurrentFrameSlotNode.doInteger(VirtualFrame, int, FrameSlotKind)], SpecializationActive[JSWriteCurrentFrameSlotNode.doSafeInteger(VirtualFrame, SafeInteger)], SpecializationActive[JSWriteCurrentFrameSlotNode.doLong(VirtualFrame, long)], SpecializationActive[JSWriteCurrentFrameSlotNode.doDouble(VirtualFrame, double)] */;
        state_0 = state_0 | 0b10 /* add SpecializationActive[JSWriteCurrentFrameSlotNode.doObject(VirtualFrame, Object)] */;
        this.state_0_ = state_0;
        return doObject(frameValue, rhsNodeValue);
    }

    @NeverDefault
    public static JSWriteCurrentFrameSlotNode create(int slot, Object identifier, JavaScriptNode rhsNode) {
        return new JSWriteCurrentFrameSlotNodeGen(slot, identifier, rhsNode);
    }

}
