// CheckStyle: start generated
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

/**
 * Debug Info: <pre>
 *   Specialization {@link ArrayCreateNode#doDefault}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link ArrayCreateNode#doLargeLength}
 *     Activation probability: 0.33333
 *     With/without class size: 8/0 bytes
 *   Specialization {@link ArrayCreateNode#doInvalidLength}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(ArrayCreateNode.class)
@SuppressWarnings("javadoc")
public final class ArrayCreateNodeGen extends ArrayCreateNode {

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link ArrayCreateNode#doDefault}
     *   1: SpecializationActive {@link ArrayCreateNode#doLargeLength}
     *   2: SpecializationActive {@link ArrayCreateNode#doInvalidLength}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private ArrayCreateNodeGen(JSContext context) {
        super(context);
    }

    @Override
    public JSArrayObject execute(long arg0Value, JSRealm arg1Value, JSDynamicObject arg2Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0 /* is SpecializationActive[ArrayCreateNode.doDefault(long, JSRealm, JSDynamicObject)] || SpecializationActive[ArrayCreateNode.doLargeLength(long, JSRealm, JSDynamicObject)] || SpecializationActive[ArrayCreateNode.doInvalidLength(long, JSRealm, JSDynamicObject)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[ArrayCreateNode.doDefault(long, JSRealm, JSDynamicObject)] */) {
                if ((JSRuntime.isValidArrayLength(arg0Value)) && (arg0Value <= Integer.MAX_VALUE)) {
                    return doDefault(arg0Value, arg1Value, arg2Value);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ArrayCreateNode.doLargeLength(long, JSRealm, JSDynamicObject)] */) {
                if ((JSRuntime.isValidArrayLength(arg0Value)) && (arg0Value > Integer.MAX_VALUE)) {
                    return doLargeLength(arg0Value, arg1Value, arg2Value);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ArrayCreateNode.doInvalidLength(long, JSRealm, JSDynamicObject)] */) {
                if ((!(JSRuntime.isValidArrayLength(arg0Value)))) {
                    return doInvalidLength(arg0Value, arg1Value, arg2Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private JSArrayObject executeAndSpecialize(long arg0Value, JSRealm arg1Value, JSDynamicObject arg2Value) {
        int state_0 = this.state_0_;
        if ((JSRuntime.isValidArrayLength(arg0Value)) && (arg0Value <= Integer.MAX_VALUE)) {
            state_0 = state_0 | 0b1 /* add SpecializationActive[ArrayCreateNode.doDefault(long, JSRealm, JSDynamicObject)] */;
            this.state_0_ = state_0;
            return doDefault(arg0Value, arg1Value, arg2Value);
        }
        if ((JSRuntime.isValidArrayLength(arg0Value)) && (arg0Value > Integer.MAX_VALUE)) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[ArrayCreateNode.doLargeLength(long, JSRealm, JSDynamicObject)] */;
            this.state_0_ = state_0;
            return doLargeLength(arg0Value, arg1Value, arg2Value);
        }
        if ((!(JSRuntime.isValidArrayLength(arg0Value)))) {
            state_0 = state_0 | 0b100 /* add SpecializationActive[ArrayCreateNode.doInvalidLength(long, JSRealm, JSDynamicObject)] */;
            this.state_0_ = state_0;
            return doInvalidLength(arg0Value, arg1Value, arg2Value);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
    }

    @NeverDefault
    public static ArrayCreateNode create(JSContext context) {
        return new ArrayCreateNodeGen(context);
    }

}
