// CheckStyle: start generated
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleString.SwitchEncodingNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link EvalNode#evalNotOverridden}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link EvalNode#evalOverridden}
 *     Activation probability: 0.35000
 *     With/without class size: 11/4 bytes
 * </pre>
 */
@GeneratedBy(EvalNode.class)
@SuppressWarnings("javadoc")
public final class EvalNodeGen extends EvalNode {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link EvalNode#evalNotOverridden}
     *   1: SpecializationActive {@link EvalNode#evalOverridden}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link EvalNode#evalOverridden}
     *   Parameter: {@link JSFunctionCallNode} redirectCall</pre>
     */
    @Child private JSFunctionCallNode evalOverridden_redirectCall_;

    private EvalNodeGen(JSContext context, JavaScriptNode function, JavaScriptNode[] args, JavaScriptNode thisObject, Object env, int blockScopeSlot) {
        super(context, function, args, thisObject, env, blockScopeSlot);
    }

    private EvalNodeGen(JSContext context, JavaScriptNode functionNode, AbstractFunctionArgumentsNode arguments, DirectEvalNode directEvalNode) {
        super(context, functionNode, arguments, directEvalNode);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object functionNodeValue_ = super.functionNode.execute(frameValue);
        if (state_0 != 0 /* is SpecializationActive[EvalNode.evalNotOverridden(VirtualFrame, Object)] || SpecializationActive[EvalNode.evalOverridden(VirtualFrame, Object, JSFunctionCallNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[EvalNode.evalNotOverridden(VirtualFrame, Object)] */) {
                if ((!(isEvalOverridden(functionNodeValue_)))) {
                    return evalNotOverridden(frameValue, functionNodeValue_);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[EvalNode.evalOverridden(VirtualFrame, Object, JSFunctionCallNode)] */) {
                {
                    JSFunctionCallNode redirectCall__ = this.evalOverridden_redirectCall_;
                    if (redirectCall__ != null) {
                        if ((isEvalOverridden(functionNodeValue_))) {
                            return evalOverridden(frameValue, functionNodeValue_, redirectCall__);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, functionNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        execute(frameValue);
        return;
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object functionNodeValue) {
        int state_0 = this.state_0_;
        if ((!(isEvalOverridden(functionNodeValue)))) {
            state_0 = state_0 | 0b1 /* add SpecializationActive[EvalNode.evalNotOverridden(VirtualFrame, Object)] */;
            this.state_0_ = state_0;
            return evalNotOverridden(frameValue, functionNodeValue);
        }
        if ((isEvalOverridden(functionNodeValue))) {
            JSFunctionCallNode redirectCall__ = this.insert((JSFunctionCallNode.createCall()));
            Objects.requireNonNull(redirectCall__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.evalOverridden_redirectCall_ = redirectCall__;
            state_0 = state_0 | 0b10 /* add SpecializationActive[EvalNode.evalOverridden(VirtualFrame, Object, JSFunctionCallNode)] */;
            this.state_0_ = state_0;
            return evalOverridden(frameValue, functionNodeValue, redirectCall__);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {super.functionNode}, functionNodeValue);
    }

    @NeverDefault
    public static EvalNode create(JSContext context, JavaScriptNode function, JavaScriptNode[] args, JavaScriptNode thisObject, Object env, int blockScopeSlot) {
        return new EvalNodeGen(context, function, args, thisObject, env, blockScopeSlot);
    }

    @NeverDefault
    public static EvalNode create(JSContext context, JavaScriptNode functionNode, AbstractFunctionArgumentsNode arguments, DirectEvalNode directEvalNode) {
        return new EvalNodeGen(context, functionNode, arguments, directEvalNode);
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link DirectEvalNode#directEvalInt}
     *     Activation probability: 0.15909
     *     With/without class size: 5/0 bytes
     *   Specialization {@link DirectEvalNode#directEvalSafeInteger}
     *     Activation probability: 0.14545
     *     With/without class size: 5/0 bytes
     *   Specialization {@link DirectEvalNode#directEvalLong}
     *     Activation probability: 0.13182
     *     With/without class size: 5/0 bytes
     *   Specialization {@link DirectEvalNode#directEvalDouble}
     *     Activation probability: 0.11818
     *     With/without class size: 5/0 bytes
     *   Specialization {@link DirectEvalNode#directEvalBoolean}
     *     Activation probability: 0.10455
     *     With/without class size: 5/0 bytes
     *   Specialization {@link DirectEvalNode#directEvalSymbol}
     *     Activation probability: 0.09091
     *     With/without class size: 5/0 bytes
     *   Specialization {@link DirectEvalNode#directEvalBigInt}
     *     Activation probability: 0.07727
     *     With/without class size: 4/0 bytes
     *   Specialization {@link DirectEvalNode#directEvalJSType}
     *     Activation probability: 0.06364
     *     With/without class size: 4/0 bytes
     *   Specialization {@link DirectEvalNode#directEvalCharSequence}
     *     Activation probability: 0.05000
     *     With/without class size: 4/0 bytes
     *   Specialization {@link DirectEvalNode#directEvalForeignObject}
     *     Activation probability: 0.03636
     *     With/without class size: 5/8 bytes
     *   Specialization {@link DirectEvalNode#directEvalForeignObject}
     *     Activation probability: 0.02273
     *     With/without class size: 4/4 bytes
     * </pre>
     */
    @GeneratedBy(DirectEvalNode.class)
    @SuppressWarnings("javadoc")
    protected static final class DirectEvalNodeGen extends DirectEvalNode {

        static final ReferenceField<DirectEvalForeignObject0Data> DIRECT_EVAL_FOREIGN_OBJECT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "directEvalForeignObject0_cache", DirectEvalForeignObject0Data.class);

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link DirectEvalNode#directEvalInt}
         *   1: SpecializationActive {@link DirectEvalNode#directEvalSafeInteger}
         *   2: SpecializationActive {@link DirectEvalNode#directEvalLong}
         *   3: SpecializationActive {@link DirectEvalNode#directEvalDouble}
         *   4: SpecializationActive {@link DirectEvalNode#directEvalBoolean}
         *   5: SpecializationActive {@link DirectEvalNode#directEvalSymbol}
         *   6: SpecializationActive {@link DirectEvalNode#directEvalBigInt}
         *   7: SpecializationActive {@link DirectEvalNode#directEvalJSType}
         *   8: SpecializationActive {@link DirectEvalNode#directEvalCharSequence}
         *   9: SpecializationActive {@link DirectEvalNode#directEvalForeignObject}
         *   10: SpecializationActive {@link DirectEvalNode#directEvalForeignObject}
         *   11-13: ImplicitCast[type=double, index=0]
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private DirectEvalForeignObject0Data directEvalForeignObject0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link DirectEvalNode#directEvalForeignObject}
         *   Parameter: {@link SwitchEncodingNode} switchEncoding</pre>
         */
        @Child private SwitchEncodingNode directEvalForeignObject1_switchEncoding_;

        private DirectEvalNodeGen(JSContext context, JavaScriptNode thisNode, Object currEnv, int blockScopeSlot) {
            super(context, thisNode, currEnv, blockScopeSlot);
        }

        @ExplodeLoop
        @Override
        public Object executeWithSource(VirtualFrame frameValue, Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111111111) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalInt(int)] || SpecializationActive[EvalNode.DirectEvalNode.directEvalSafeInteger(SafeInteger)] || SpecializationActive[EvalNode.DirectEvalNode.directEvalLong(long)] || SpecializationActive[EvalNode.DirectEvalNode.directEvalDouble(double)] || SpecializationActive[EvalNode.DirectEvalNode.directEvalBoolean(boolean)] || SpecializationActive[EvalNode.DirectEvalNode.directEvalSymbol(Symbol)] || SpecializationActive[EvalNode.DirectEvalNode.directEvalBigInt(BigInt)] || SpecializationActive[EvalNode.DirectEvalNode.directEvalJSType(JSDynamicObject)] || SpecializationActive[EvalNode.DirectEvalNode.directEvalCharSequence(VirtualFrame, TruffleString)] || SpecializationActive[EvalNode.DirectEvalNode.directEvalForeignObject(VirtualFrame, Object, InteropLibrary, SwitchEncodingNode)] || SpecializationActive[EvalNode.DirectEvalNode.directEvalForeignObject(VirtualFrame, Object, InteropLibrary, SwitchEncodingNode)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalInt(int)] */ && arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    return directEvalInt(arg0Value_);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalSafeInteger(SafeInteger)] */ && arg0Value instanceof SafeInteger) {
                    SafeInteger arg0Value_ = (SafeInteger) arg0Value;
                    return directEvalSafeInteger(arg0Value_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalLong(long)] */ && arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    return directEvalLong(arg0Value_);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                    double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                    return directEvalDouble(arg0Value_);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    return directEvalBoolean(arg0Value_);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalSymbol(Symbol)] */ && arg0Value instanceof Symbol) {
                    Symbol arg0Value_ = (Symbol) arg0Value;
                    return directEvalSymbol(arg0Value_);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalBigInt(BigInt)] */ && arg0Value instanceof BigInt) {
                    BigInt arg0Value_ = (BigInt) arg0Value;
                    return directEvalBigInt(arg0Value_);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalJSType(JSDynamicObject)] */ && arg0Value instanceof JSDynamicObject) {
                    JSDynamicObject arg0Value_ = (JSDynamicObject) arg0Value;
                    return directEvalJSType(arg0Value_);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalCharSequence(VirtualFrame, TruffleString)] */ && arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    return directEvalCharSequence(frameValue, arg0Value_);
                }
                if ((state_0 & 0b11000000000) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalForeignObject(VirtualFrame, Object, InteropLibrary, SwitchEncodingNode)] || SpecializationActive[EvalNode.DirectEvalNode.directEvalForeignObject(VirtualFrame, Object, InteropLibrary, SwitchEncodingNode)] */) {
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalForeignObject(VirtualFrame, Object, InteropLibrary, SwitchEncodingNode)] */) {
                        DirectEvalForeignObject0Data s9_ = this.directEvalForeignObject0_cache;
                        while (s9_ != null) {
                            if ((s9_.interop_.accepts(arg0Value)) && (JSGuards.isForeignObject(arg0Value))) {
                                return directEvalForeignObject(frameValue, arg0Value, s9_.interop_, s9_.switchEncoding_);
                            }
                            s9_ = s9_.next_;
                        }
                    }
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[EvalNode.DirectEvalNode.directEvalForeignObject(VirtualFrame, Object, InteropLibrary, SwitchEncodingNode)] */) {
                        {
                            SwitchEncodingNode switchEncoding__ = this.directEvalForeignObject1_switchEncoding_;
                            if (switchEncoding__ != null) {
                                if ((JSGuards.isForeignObject(arg0Value))) {
                                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                    Node prev_ = encapsulating_.set(this);
                                    try {
                                        {
                                            InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                            return directEvalForeignObject(frameValue, arg0Value, interop__, switchEncoding__);
                                        }
                                    } finally {
                                        encapsulating_.set(prev_);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, arg0Value);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
            int state_0 = this.state_0_;
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                state_0 = state_0 | 0b1 /* add SpecializationActive[EvalNode.DirectEvalNode.directEvalInt(int)] */;
                this.state_0_ = state_0;
                return directEvalInt(arg0Value_);
            }
            if (arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger) arg0Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[EvalNode.DirectEvalNode.directEvalSafeInteger(SafeInteger)] */;
                this.state_0_ = state_0;
                return directEvalSafeInteger(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                state_0 = state_0 | 0b100 /* add SpecializationActive[EvalNode.DirectEvalNode.directEvalLong(long)] */;
                this.state_0_ = state_0;
                return directEvalLong(arg0Value_);
            }
            {
                int doubleCast0;
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                    double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 = (state_0 | (doubleCast0 << 11) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[EvalNode.DirectEvalNode.directEvalDouble(double)] */;
                    this.state_0_ = state_0;
                    return directEvalDouble(arg0Value_);
                }
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[EvalNode.DirectEvalNode.directEvalBoolean(boolean)] */;
                this.state_0_ = state_0;
                return directEvalBoolean(arg0Value_);
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol) arg0Value;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[EvalNode.DirectEvalNode.directEvalSymbol(Symbol)] */;
                this.state_0_ = state_0;
                return directEvalSymbol(arg0Value_);
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[EvalNode.DirectEvalNode.directEvalBigInt(BigInt)] */;
                this.state_0_ = state_0;
                return directEvalBigInt(arg0Value_);
            }
            if (arg0Value instanceof JSDynamicObject) {
                JSDynamicObject arg0Value_ = (JSDynamicObject) arg0Value;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[EvalNode.DirectEvalNode.directEvalJSType(JSDynamicObject)] */;
                this.state_0_ = state_0;
                return directEvalJSType(arg0Value_);
            }
            if (arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[EvalNode.DirectEvalNode.directEvalCharSequence(VirtualFrame, TruffleString)] */;
                this.state_0_ = state_0;
                return directEvalCharSequence(frameValue, arg0Value_);
            }
            if (((state_0 & 0b10000000000)) == 0 /* is-not SpecializationActive[EvalNode.DirectEvalNode.directEvalForeignObject(VirtualFrame, Object, InteropLibrary, SwitchEncodingNode)] */) {
                while (true) {
                    int count9_ = 0;
                    DirectEvalForeignObject0Data s9_ = DIRECT_EVAL_FOREIGN_OBJECT0_CACHE_UPDATER.getVolatile(this);
                    DirectEvalForeignObject0Data s9_original = s9_;
                    while (s9_ != null) {
                        if ((s9_.interop_.accepts(arg0Value)) && (JSGuards.isForeignObject(arg0Value))) {
                            break;
                        }
                        count9_++;
                        s9_ = s9_.next_;
                    }
                    if (s9_ == null) {
                        if ((JSGuards.isForeignObject(arg0Value)) && count9_ < (3)) {
                            // assert (s9_.interop_.accepts(arg0Value));
                            s9_ = this.insert(new DirectEvalForeignObject0Data(s9_original));
                            InteropLibrary interop__ = s9_.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s9_.interop_ = interop__;
                            SwitchEncodingNode switchEncoding__ = s9_.insert((SwitchEncodingNode.create()));
                            Objects.requireNonNull(switchEncoding__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s9_.switchEncoding_ = switchEncoding__;
                            if (!DIRECT_EVAL_FOREIGN_OBJECT0_CACHE_UPDATER.compareAndSet(this, s9_original, s9_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[EvalNode.DirectEvalNode.directEvalForeignObject(VirtualFrame, Object, InteropLibrary, SwitchEncodingNode)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s9_ != null) {
                        return directEvalForeignObject(frameValue, arg0Value, s9_.interop_, s9_.switchEncoding_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        if ((JSGuards.isForeignObject(arg0Value))) {
                            interop__ = (INTEROP_LIBRARY_.getUncached());
                            SwitchEncodingNode switchEncoding__ = this.insert((SwitchEncodingNode.create()));
                            Objects.requireNonNull(switchEncoding__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.directEvalForeignObject1_switchEncoding_ = switchEncoding__;
                            this.directEvalForeignObject0_cache = null;
                            state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[EvalNode.DirectEvalNode.directEvalForeignObject(VirtualFrame, Object, InteropLibrary, SwitchEncodingNode)] */;
                            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[EvalNode.DirectEvalNode.directEvalForeignObject(VirtualFrame, Object, InteropLibrary, SwitchEncodingNode)] */;
                            this.state_0_ = state_0;
                            return directEvalForeignObject(frameValue, arg0Value, interop__, switchEncoding__);
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value);
        }

        @NeverDefault
        public static DirectEvalNode create(JSContext context, JavaScriptNode thisNode, Object currEnv, int blockScopeSlot) {
            return new DirectEvalNodeGen(context, thisNode, currEnv, blockScopeSlot);
        }

        @GeneratedBy(DirectEvalNode.class)
        @DenyReplace
        private static final class DirectEvalForeignObject0Data extends Node implements SpecializationDataNode {

            @Child DirectEvalForeignObject0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DirectEvalNode#directEvalForeignObject}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DirectEvalNode#directEvalForeignObject}
             *   Parameter: {@link SwitchEncodingNode} switchEncoding</pre>
             */
            @Child SwitchEncodingNode switchEncoding_;

            DirectEvalForeignObject0Data(DirectEvalForeignObject0Data next_) {
                this.next_ = next_;
            }

        }
    }
}
