/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNode;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.interop.InteropArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.util.JSHashMap;

@ExportLibrary(value=InteropLibrary.class)
public final class JSMapObject
extends JSNonProxyObject {
    private final JSHashMap map;

    protected JSMapObject(Shape shape, JSDynamicObject proto, JSHashMap map) {
        super(shape, proto);
        this.map = map;
    }

    public JSHashMap getMap() {
        return this.map;
    }

    @Override
    public TruffleString getClassName() {
        return JSMap.CLASS_NAME;
    }

    @ExportMessage
    public boolean hasHashEntries() {
        return true;
    }

    @ExportMessage
    long getHashSize() {
        return this.getMap().size();
    }

    @ExportMessage
    Object getHashEntriesIterator() {
        return new EntriesIterator(this.getMap().getEntries());
    }

    @ExportMessage
    boolean isHashEntryReadable(Object key, @Cached @Cached.Shared ImportValueNode importKeyNode, @Cached @Cached.Shared JSCollectionsNormalizeNode normalizeKeyNode) {
        Object normalizedKey = normalizeKeyNode.execute(importKeyNode.executeWithTarget(key));
        return this.getMap().has(normalizedKey);
    }

    @ExportMessage
    Object readHashValue(Object key, @Cached @Cached.Shared ExportValueNode exportValueNode, @Cached @Cached.Shared ImportValueNode importKeyNode, @Cached @Cached.Shared JSCollectionsNormalizeNode normalizeKeyNode) throws UnknownKeyException {
        Object normalizedKey = normalizeKeyNode.execute(importKeyNode.executeWithTarget(key));
        Object value = this.getMap().get(normalizedKey);
        if (value == null) {
            throw UnknownKeyException.create((Object)key);
        }
        return exportValueNode.execute(value);
    }

    @ExportMessage
    Object readHashValueOrDefault(Object key, Object defaultValue, @Cached @Cached.Shared ExportValueNode exportValueNode, @Cached @Cached.Shared ImportValueNode importKeyNode, @Cached @Cached.Shared JSCollectionsNormalizeNode normalizeKeyNode) {
        Object normalizedKey = normalizeKeyNode.execute(importKeyNode.executeWithTarget(key));
        Object value = this.getMap().get(normalizedKey);
        if (value == null) {
            return defaultValue;
        }
        return exportValueNode.execute(value);
    }

    @ExportMessage.Repeat(value={@ExportMessage, @ExportMessage(name="isHashEntryRemovable")})
    boolean isHashEntryModifiable(Object key, @Cached @Cached.Shared ImportValueNode importKeyNode, @Cached @Cached.Shared JSCollectionsNormalizeNode normalizeKeyNode) {
        Object normalizedKey = normalizeKeyNode.execute(importKeyNode.executeWithTarget(key));
        return this.getMap().has(normalizedKey);
    }

    @ExportMessage
    boolean isHashEntryInsertable(Object key, @CachedLibrary(value="this") InteropLibrary thisLibrary) {
        return !thisLibrary.isHashEntryModifiable((Object)this, key);
    }

    @ExportMessage
    void writeHashEntry(Object key, Object value, @Cached @Cached.Shared ImportValueNode importKeyNode, @Cached @Cached.Exclusive ImportValueNode importValueNode, @Cached @Cached.Shared JSCollectionsNormalizeNode normalizeKeyNode) {
        Object normalizedKey = normalizeKeyNode.execute(importKeyNode.executeWithTarget(key));
        this.getMap().put(normalizedKey, importValueNode.executeWithTarget(value));
    }

    @ExportMessage
    void removeHashEntry(Object key, @Cached @Cached.Shared ImportValueNode importKeyNode, @Cached @Cached.Shared JSCollectionsNormalizeNode normalizeKeyNode) throws UnknownKeyException {
        Object normalizedKey = normalizeKeyNode.execute(importKeyNode.executeWithTarget(key));
        if (!this.getMap().remove(normalizedKey)) {
            throw UnknownKeyException.create((Object)key);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return Strings.concatAll(Strings.BRACKET_OPEN, this.getClassName(), Strings.BRACKET_CLOSE);
        }
        return JSRuntime.collectionToConsoleString(this, allowSideEffects, format, this.getClassName(), JSMap.getInternalMap(this), depth);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class EntriesIterator
    implements TruffleObject {
        private JSHashMap.Cursor cursor;
        private Boolean hasNext;

        private EntriesIterator(JSHashMap.Cursor cursor) {
            this.cursor = cursor;
        }

        @ExportMessage
        boolean isIterator() {
            return true;
        }

        @ExportMessage
        boolean hasIteratorNextElement() {
            if (this.hasNext == null) {
                this.hasNext = this.cursor.advance();
            }
            return this.hasNext;
        }

        @ExportMessage
        Object getIteratorNextElement() throws StopIterationException {
            if (this.hasIteratorNextElement()) {
                InteropArray entryTuple = InteropArray.create(new Object[]{this.cursor.getKey(), this.cursor.getValue()});
                this.hasNext = null;
                return entryTuple;
            }
            throw StopIterationException.create();
        }
    }
}

