/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.Errors;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static <T> List<T> concatLists(final List<T> list0, final List<T> list1) {
        int size1;
        final int size0 = list0.size();
        final int size = size0 + (size1 = list1.size());
        if (size < 0) {
            throw Errors.createRangeErrorInvalidArrayLength();
        }
        if (size0 == 0) {
            return list1;
        }
        if (size1 == 0) {
            return list0;
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index >= 0 && index < size0) {
                    return list0.get(index);
                }
                if (index >= 0 && index < size) {
                    return list1.get(index - size0);
                }
                throw this.outOfBounds(index);
            }

            @Override
            public int size() {
                return size;
            }

            @CompilerDirectives.TruffleBoundary
            private IndexOutOfBoundsException outOfBounds(int index) {
                return new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
            }
        };
    }

    public static <T> Iterator<T> simpleArrayIterator(final T[] array) {
        return new Iterator<T>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor < array.length;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return array[this.cursor++];
                }
                throw new NoSuchElementException();
            }
        };
    }
}

