/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.scriptengine;

import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.graalvm.polyglot.Engine;

public final class GraalJSEngineFactory
implements ScriptEngineFactory {
    private static final String ENGINE_NAME = "Graal.js";
    private static final String NAME = "javascript";
    private static final String LANGUAGE = "ECMAScript";
    private static final String LANGUAGE_VERSION = "ECMA - 262 Edition 9";
    private static final String NASHORN_ENGINE_NAME = "Oracle Nashorn";
    private static final List<String> names;
    private static final List<String> mimeTypes;
    private static final List<String> extensions;
    public static final boolean RegisterAsNashornScriptEngineFactory;
    private final Engine engine;

    public GraalJSEngineFactory() {
        this.engine = Engine.newBuilder().allowExperimentalOptions(true).build();
    }

    GraalJSEngineFactory(Engine engine) {
        this.engine = engine;
    }

    public Engine getPolyglotEngine() {
        return this.engine;
    }

    @Override
    public String getEngineName() {
        return ENGINE_NAME;
    }

    @Override
    public String getEngineVersion() {
        return this.engine.getVersion();
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getLanguageName() {
        return LANGUAGE;
    }

    @Override
    public String getLanguageVersion() {
        return LANGUAGE_VERSION;
    }

    @Override
    public Object getParameter(String key) {
        switch (key) {
            case "javax.script.name": {
                return NAME;
            }
            case "javax.script.engine": {
                return this.getEngineName();
            }
            case "javax.script.engine_version": {
                return this.getEngineVersion();
            }
            case "javax.script.language": {
                return this.getLanguageName();
            }
            case "javax.script.language_version": {
                return this.getLanguageVersion();
            }
        }
        return null;
    }

    @Override
    public GraalJSScriptEngine getScriptEngine() {
        return new GraalJSScriptEngine(this);
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        Objects.requireNonNull(obj);
        Objects.requireNonNull(method);
        StringBuilder sb = new StringBuilder().append(obj).append('.').append(method).append('(');
        int len = args.length;
        if (len > 0) {
            Objects.requireNonNull(args[0]);
            sb.append(args[0]);
        }
        for (int i = 1; i < len; ++i) {
            Objects.requireNonNull(args[i]);
            sb.append(',').append(args[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "print(" + toDisplay + ")";
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder sb = new StringBuilder();
        for (String statement : statements) {
            Objects.requireNonNull(statement);
            sb.append(statement).append(';');
        }
        return sb.toString();
    }

    private static ScriptEngineFactory getNashornEngineFactory() {
        for (ScriptEngineFactory factory : new ScriptEngineManager().getEngineFactories()) {
            if (!NASHORN_ENGINE_NAME.equals(factory.getEngineName())) continue;
            return factory;
        }
        return null;
    }

    private static void clearEngineFactory(ScriptEngineFactory factory) {
        assert (factory != null);
        try {
            Class<?> clazz = factory.getClass();
            for (String immutableListFieldName : new String[]{"names", "mimeTypes", "extensions"}) {
                Field immutableListField = clazz.getDeclaredField(immutableListFieldName);
                immutableListField.setAccessible(true);
                Object immutableList = immutableListField.get(null);
                Class<?> unmodifiableListClazz = Class.forName("java.util.Collections$UnmodifiableList");
                Field unmodifiableListField = unmodifiableListClazz.getDeclaredField("list");
                unmodifiableListField.setAccessible(true);
                List list = (List)unmodifiableListField.get(immutableList);
                for (int i = 0; i < list.size(); ++i) {
                    if (!RegisterAsNashornScriptEngineFactory && list.get(i).toString().toLowerCase().equals("nashorn")) continue;
                    list.set(i, null);
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NullPointerException | SecurityException e) {
            System.err.println("Failed to clear engine names [" + factory.getEngineName() + "]");
            e.printStackTrace();
        }
    }

    static {
        ScriptEngineFactory nashornFactory;
        boolean java8;
        RegisterAsNashornScriptEngineFactory = Boolean.getBoolean("graaljs.RegisterGraalJSAsNashorn");
        ArrayList<String> nameList = new ArrayList<String>(Arrays.asList(ENGINE_NAME, "graal.js", "Graal-js", "graal-js", "Graal.JS", "Graal-JS", "GraalJS", "GraalJSPolyglot", "js", "JS", "JavaScript", NAME, LANGUAGE, "ecmascript"));
        ArrayList<String> mimeTypeList = new ArrayList<String>(Arrays.asList("application/javascript", "application/ecmascript", "text/javascript", "text/ecmascript"));
        ArrayList<String> extensionList = new ArrayList<String>(Arrays.asList("js", "mjs"));
        boolean bl = java8 = System.getProperty("java.specification.version").compareTo("1.9") < 0;
        if (java8 && (nashornFactory = GraalJSEngineFactory.getNashornEngineFactory()) != null) {
            if (RegisterAsNashornScriptEngineFactory) {
                nameList.addAll(nashornFactory.getNames());
                mimeTypeList.addAll(nashornFactory.getMimeTypes());
                extensionList.addAll(nashornFactory.getExtensions());
            }
            GraalJSEngineFactory.clearEngineFactory(nashornFactory);
        }
        names = Collections.unmodifiableList(nameList);
        mimeTypes = Collections.unmodifiableList(mimeTypeList);
        extensions = Collections.unmodifiableList(extensionList);
    }
}

