/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.objects.pickle;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.enterprise.builtins.nodes.EnterpriseErrorMessages;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PDataFactory;
import com.oracle.graal.python.nodes.PNodeWithState;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.Specialization;

public class PData {
    Object[] data = new Object[8];
    boolean mark = false;
    int fence = 0;
    int size = 0;

    public int getSize() {
        return this.size;
    }

    public void clear(int clearTo) {
        assert (clearTo >= this.fence);
        int i = this.size;
        if (clearTo >= i) {
            return;
        }
        while (--i >= clearTo) {
            this.data[i] = null;
        }
        this.size = clearTo;
    }

    public void grow() throws OverflowException {
        int newAllocated = this.data.length << 1;
        if (newAllocated <= 0) {
            throw OverflowException.INSTANCE;
        }
        this.data = PythonUtils.arrayCopyOf((Object[])this.data, (int)newAllocated);
    }

    @GenerateNodeFactory
    public static abstract class PDataPopListNode
    extends PDataBaseNode {
        public abstract PList execute(PData var1, int var2);

        @Specialization
        public PList popList(PData self, int start) {
            int len = self.size - start;
            Object[] items = new Object[len];
            int i = start;
            for (int j = 0; j < len; ++j) {
                items[j] = self.data[i];
                ++i;
            }
            self.size = start;
            return this.factory().createList(items);
        }

        public static PDataPopListNode create() {
            return PDataFactory.PDataPopListNodeFactory.create();
        }
    }

    @GenerateNodeFactory
    public static abstract class PDataPopTupleNode
    extends PDataBaseNode {
        public abstract PTuple execute(PData var1, int var2);

        @Specialization
        public PTuple popTuple(PData self, int start) {
            if (start < self.fence) {
                throw this.raiseUnderflow(self);
            }
            int len = self.size - start;
            Object[] items = new Object[len];
            int i = start;
            for (int j = 0; j < len; ++j) {
                items[j] = self.data[i];
                ++i;
            }
            self.size = start;
            return this.factory().createTuple(items);
        }

        public static PDataPopTupleNode create() {
            return PDataFactory.PDataPopTupleNodeFactory.create();
        }
    }

    @GenerateNodeFactory
    public static abstract class PDataPushNode
    extends PDataBaseNode {
        public abstract void execute(PData var1, Object var2);

        @Specialization
        public void push(PData self, Object obj) {
            if (self.size == self.data.length) {
                try {
                    self.grow();
                }
                catch (OverflowException e) {
                    throw this.raiseOverflow();
                }
            }
            self.data[self.size++] = obj;
        }

        public static PDataPushNode create() {
            return PDataFactory.PDataPushNodeFactory.create();
        }
    }

    @GenerateNodeFactory
    public static abstract class PDataPopNode
    extends PDataBaseNode {
        public abstract Object execute(PData var1);

        @Specialization
        public Object pop(PData self) {
            if (self.size <= self.fence) {
                throw this.raiseUnderflow(self);
            }
            return self.data[--self.size];
        }

        public static PDataPopNode create() {
            return PDataFactory.PDataPopNodeFactory.create();
        }
    }

    public static abstract class PDataBaseNode
    extends PNodeWithState {
        public PException raiseUnderflow(PData self) {
            return this.raise(PythonBuiltinClassType.UnpicklingError, self.mark ? EnterpriseErrorMessages.PDATA_UNEXPECTED_MARK_FOUND : EnterpriseErrorMessages.PDATA_UNPICKLING_STACK_UNDERFLOW);
        }
    }
}

