/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RunInTerminalRequestArguments
extends JSONBase {
    RunInTerminalRequestArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public String getKind() {
        return this.jsonData.optString("kind", null);
    }

    public RunInTerminalRequestArguments setKind(String kind) {
        this.jsonData.putOpt("kind", kind);
        return this;
    }

    public String getTitle() {
        return this.jsonData.optString("title", null);
    }

    public RunInTerminalRequestArguments setTitle(String title) {
        this.jsonData.putOpt("title", title);
        return this;
    }

    public String getCwd() {
        return this.jsonData.getString("cwd");
    }

    public RunInTerminalRequestArguments setCwd(String cwd) {
        this.jsonData.put("cwd", cwd);
        return this;
    }

    public List<String> getArgs() {
        JSONArray json = this.jsonData.getJSONArray("args");
        ArrayList<String> list = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getString(i));
        }
        return Collections.unmodifiableList(list);
    }

    public RunInTerminalRequestArguments setArgs(List<String> args) {
        JSONArray json = new JSONArray();
        for (String string : args) {
            json.put(string);
        }
        this.jsonData.put("args", json);
        return this;
    }

    public Map<String, String> getEnv() {
        JSONObject json = this.jsonData.optJSONObject("env");
        if (json == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(json.length());
        for (String key : json.keySet()) {
            map.put(key, json.getString(key));
        }
        return map;
    }

    public RunInTerminalRequestArguments setEnv(Map<String, String> env) {
        if (env != null) {
            JSONObject json = new JSONObject();
            for (Map.Entry<String, String> entry : env.entrySet()) {
                json.put(entry.getKey(), entry.getValue());
            }
            this.jsonData.put("env", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunInTerminalRequestArguments other = (RunInTerminalRequestArguments)obj;
        if (!Objects.equals(this.getKind(), other.getKind())) {
            return false;
        }
        if (!Objects.equals(this.getTitle(), other.getTitle())) {
            return false;
        }
        if (!Objects.equals(this.getCwd(), other.getCwd())) {
            return false;
        }
        if (!Objects.equals(this.getArgs(), other.getArgs())) {
            return false;
        }
        return Objects.equals(this.getEnv(), other.getEnv());
    }

    public int hashCode() {
        int hash = 5;
        if (this.getKind() != null) {
            hash = 97 * hash + Objects.hashCode(this.getKind());
        }
        if (this.getTitle() != null) {
            hash = 97 * hash + Objects.hashCode(this.getTitle());
        }
        hash = 97 * hash + Objects.hashCode(this.getCwd());
        hash = 97 * hash + Objects.hashCode(this.getArgs());
        if (this.getEnv() != null) {
            hash = 97 * hash + Objects.hashCode(this.getEnv());
        }
        return hash;
    }

    public static RunInTerminalRequestArguments create(String cwd, List<String> args) {
        JSONObject json = new JSONObject();
        json.put("cwd", cwd);
        JSONArray argsJsonArr = new JSONArray();
        for (String string : args) {
            argsJsonArr.put(string);
        }
        json.put("args", argsJsonArr);
        return new RunInTerminalRequestArguments(json);
    }
}

