// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.util.concurrent.locks.Lock;

@GeneratedBy(TargetMappingNode.class)
final class TargetMappingNodeGen extends TargetMappingNode {

    private static final Uncached UNCACHED = new Uncached();

    @CompilationFinal private volatile int state_0_;
    @CompilationFinal private volatile int exclude_;
    @Child private CachedData cached_cache;

    private TargetMappingNodeGen() {
    }

    @Override
    Object execute(Object arg0Value, Class<?> arg1Value, PolyglotLanguageContext arg2Value, InteropLibrary arg3Value, boolean arg4Value, int arg5Value, int arg6Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0 /* is-state_0 doCached(Object, Class<>, PolyglotLanguageContext, InteropLibrary, boolean, int, int, PolyglotTargetMapping[], SingleMappingNode[]) || doUncached(Object, Class<>, PolyglotLanguageContext, InteropLibrary, boolean, int, int) */) {
            if ((state_0 & 0b1) != 0 /* is-state_0 doCached(Object, Class<>, PolyglotLanguageContext, InteropLibrary, boolean, int, int, PolyglotTargetMapping[], SingleMappingNode[]) */) {
                CachedData s1_ = this.cached_cache;
                if (s1_ != null) {
                    if ((arg1Value != null)) {
                        return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.mappings_, s1_.mappingNodes_);
                    }
                }
            }
            if ((state_0 & 0b10) != 0 /* is-state_0 doUncached(Object, Class<>, PolyglotLanguageContext, InteropLibrary, boolean, int, int) */) {
                return doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
    }

    private Object executeAndSpecialize(Object arg0Value, Class<?> arg1Value, PolyglotLanguageContext arg2Value, InteropLibrary arg3Value, boolean arg4Value, int arg5Value, int arg6Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            if ((exclude) == 0 /* is-not-exclude doCached(Object, Class<>, PolyglotLanguageContext, InteropLibrary, boolean, int, int, PolyglotTargetMapping[], SingleMappingNode[]) */) {
                if ((arg1Value != null)) {
                    CachedData s1_ = super.insert(new CachedData());
                    s1_.mappings_ = (TargetMappingNode.getMappings(arg2Value, arg1Value));
                    s1_.mappingNodes_ = s1_.insertAccessor((TargetMappingNode.createMappingNodes(s1_.mappings_)));
                    this.cached_cache = s1_;
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doCached(Object, Class<>, PolyglotLanguageContext, InteropLibrary, boolean, int, int, PolyglotTargetMapping[], SingleMappingNode[]) */;
                    lock.unlock();
                    hasLock = false;
                    return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.mappings_, s1_.mappingNodes_);
                }
            }
            this.exclude_ = exclude = exclude | 0b1 /* add-exclude doCached(Object, Class<>, PolyglotLanguageContext, InteropLibrary, boolean, int, int, PolyglotTargetMapping[], SingleMappingNode[]) */;
            this.cached_cache = null;
            state_0 = state_0 & 0xfffffffe /* remove-state_0 doCached(Object, Class<>, PolyglotLanguageContext, InteropLibrary, boolean, int, int, PolyglotTargetMapping[], SingleMappingNode[]) */;
            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doUncached(Object, Class<>, PolyglotLanguageContext, InteropLibrary, boolean, int, int) */;
            lock.unlock();
            hasLock = false;
            return doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static TargetMappingNode create() {
        return new TargetMappingNodeGen();
    }

    public static TargetMappingNode getUncached() {
        return TargetMappingNodeGen.UNCACHED;
    }

    @GeneratedBy(TargetMappingNode.class)
    private static final class CachedData extends Node {

        @CompilationFinal(dimensions = 1) PolyglotTargetMapping[] mappings_;
        @Children SingleMappingNode[] mappingNodes_;

        CachedData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T[] insertAccessor(T[] node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(TargetMappingNode.class)
    private static final class Uncached extends TargetMappingNode {

        @TruffleBoundary
        @Override
        Object execute(Object arg0Value, Class<?> arg1Value, PolyglotLanguageContext arg2Value, InteropLibrary arg3Value, boolean arg4Value, int arg5Value, int arg6Value) {
            return doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(SingleMappingNode.class)
    static final class SingleMappingNodeGen extends SingleMappingNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private DefaultData default_cache;

        private SingleMappingNodeGen() {
        }

        @Override
        Object execute(Object arg0Value, PolyglotTargetMapping arg1Value, PolyglotLanguageContext arg2Value, InteropLibrary arg3Value, boolean arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doDefault(Object, PolyglotTargetMapping, PolyglotLanguageContext, InteropLibrary, boolean, ConditionProfile, boolean, ToHostNode) */) {
                DefaultData s1_ = this.default_cache;
                if (s1_ != null) {
                    return doDefault(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.acceptsProfile_, s1_.allowsImplementation_, s1_.toHostRecursive_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private Object executeAndSpecialize(Object arg0Value, PolyglotTargetMapping arg1Value, PolyglotLanguageContext arg2Value, InteropLibrary arg3Value, boolean arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                DefaultData s1_ = super.insert(new DefaultData());
                s1_.acceptsProfile_ = (ConditionProfile.create());
                s1_.allowsImplementation_ = (SingleMappingNode.allowsImplementation(arg2Value, arg1Value.sourceType));
                s1_.toHostRecursive_ = s1_.insertAccessor((ToHostNodeGen.create()));
                this.default_cache = s1_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doDefault(Object, PolyglotTargetMapping, PolyglotLanguageContext, InteropLibrary, boolean, ConditionProfile, boolean, ToHostNode) */;
                lock.unlock();
                hasLock = false;
                return doDefault(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.acceptsProfile_, s1_.allowsImplementation_, s1_.toHostRecursive_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static SingleMappingNode create() {
            return new SingleMappingNodeGen();
        }

        public static SingleMappingNode getUncached() {
            return SingleMappingNodeGen.UNCACHED;
        }

        @GeneratedBy(SingleMappingNode.class)
        private static final class DefaultData extends Node {

            @CompilationFinal ConditionProfile acceptsProfile_;
            @CompilationFinal boolean allowsImplementation_;
            @Child ToHostNode toHostRecursive_;

            DefaultData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(SingleMappingNode.class)
        private static final class Uncached extends SingleMappingNode {

            @TruffleBoundary
            @Override
            Object execute(Object arg0Value, PolyglotTargetMapping arg1Value, PolyglotLanguageContext arg2Value, InteropLibrary arg3Value, boolean arg4Value) {
                return doDefault(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (ConditionProfile.getUncached()), (SingleMappingNode.allowsImplementation(arg2Value, arg1Value.sourceType)), (ToHostNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
