/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSFileSystemGen;
import com.oracle.truffle.polyglot.enterprise.HSInputStreamGen;
import com.oracle.truffle.polyglot.enterprise.HSLogHandlerGen;
import com.oracle.truffle.polyglot.enterprise.HSMessageTransportGen;
import com.oracle.truffle.polyglot.enterprise.HSOutputStreamGen;
import com.oracle.truffle.polyglot.enterprise.HSPolyglotHostServicesGen;
import com.oracle.truffle.polyglot.enterprise.HSPolyglotObject;
import com.oracle.truffle.polyglot.enterprise.HSProcessHandlerGen;
import com.oracle.truffle.polyglot.enterprise.IsolateSourceCache;
import com.oracle.truffle.polyglot.enterprise.NativeIsolateSourceCacheGen;
import com.oracle.truffle.polyglot.enterprise.NativePolyglotIsolateServices;
import com.oracle.truffle.polyglot.enterprise.PolyglotHostServices;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateServices;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.Map;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObject;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativebridge.TypeLiteral;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.io.ProcessHandler;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class NativePolyglotIsolateServicesGen {
    NativePolyglotIsolateServicesGen() {
    }

    static NativePolyglotIsolateServices createHSToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativePolyglotIsolateServices createNativeToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativePolyglotIsolateServices create(NativeIsolate nativeIsolate, long l2) {
        if (ImageInfo.inImageCode()) {
            return NativePolyglotIsolateServicesGen.createNativeToNative(nativeIsolate, l2);
        }
        return NativePolyglotIsolateServicesGen.createHSToNative(nativeIsolate, l2);
    }

    private static final class StartPoint
    extends NativePolyglotIsolateServices {
        private static final BinaryMarshaller<Map<String, String[]>> mapOfStringStringArrayMarshaller;
        private static final BinaryMarshaller<Map<String, String>> mapOfStringStringMarshaller;
        private static final BinaryMarshaller<Object> objectWithEnvironmentAccessByValueMarshaller;
        private static final BinaryMarshaller<Object> objectWithIOAccessByValueMarshaller;
        private static final BinaryMarshaller<Object> objectWithPolyglotAccessByValueMarshaller;
        private static final BinaryMarshaller<Object> objectWithValueReceiverMarshaller;
        private static final BinaryMarshaller<SandboxPolicy> sandboxPolicyMarshaller;
        private static final BinaryMarshaller<String> stringMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<ZoneId> zoneIdMarshaller;
        private volatile IsolateSourceCache getSourceCacheCache;

        StartPoint(NativeIsolate nativeIsolate, long l2) {
            super(nativeIsolate, l2);
        }

        @Override
        public long buildEngine(String[] stringArray, SandboxPolicy sandboxPolicy, OutputStream outputStream, OutputStream outputStream2, InputStream inputStream, Map<String, String> map, boolean bl, boolean bl2, MessageTransport messageTransport, AbstractPolyglotImpl.LogHandler logHandler, Object object) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int n2 = 4 + (stringArray != null && stringArray.length > 0 ? stringArray.length * stringMarshaller.inferSize((Object)stringArray[0]) : 0) + sandboxPolicyMarshaller.inferSize((Object)sandboxPolicy) + mapOfStringStringMarshaller.inferSize(map);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create((int)n2);
                if (stringArray != null) {
                    byteArrayBinaryOutput.writeInt(stringArray.length);
                    for (String string : stringArray) {
                        stringMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)string);
                    }
                } else {
                    byteArrayBinaryOutput.writeInt(-1);
                }
                sandboxPolicyMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)sandboxPolicy);
                mapOfStringStringMarshaller.write((BinaryOutput)byteArrayBinaryOutput, map);
                long l2 = StartPoint.buildEngine0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), outputStream, outputStream2, inputStream, bl, bl2, messageTransport, logHandler, object, byteArrayBinaryOutput.getArray());
                return l2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public long createContext(Object object, SandboxPolicy sandboxPolicy, OutputStream outputStream, OutputStream outputStream2, InputStream inputStream, boolean bl, Object object2, Object object3, FileSystem fileSystem, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, Map<String, String[]> map2, String[] stringArray, String string, String string2, ProcessHandler processHandler, Object object4, Map<String, String> map3, ZoneId zoneId, long l2, Object object5, boolean bl8, boolean bl9, AbstractPolyglotImpl.LogHandler logHandler, Object object6) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int n2 = sandboxPolicyMarshaller.inferSize((Object)sandboxPolicy) + objectWithPolyglotAccessByValueMarshaller.inferSize(object2) + objectWithIOAccessByValueMarshaller.inferSize(object3) + mapOfStringStringMarshaller.inferSize(map) + mapOfStringStringArrayMarshaller.inferSize(map2) + 4 + (stringArray != null && stringArray.length > 0 ? stringArray.length * stringMarshaller.inferSize((Object)stringArray[0]) : 0) + objectWithEnvironmentAccessByValueMarshaller.inferSize(object4) + mapOfStringStringMarshaller.inferSize(map3) + zoneIdMarshaller.inferSize((Object)zoneId);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create((int)n2);
                sandboxPolicyMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)sandboxPolicy);
                objectWithPolyglotAccessByValueMarshaller.write((BinaryOutput)byteArrayBinaryOutput, object2);
                objectWithIOAccessByValueMarshaller.write((BinaryOutput)byteArrayBinaryOutput, object3);
                mapOfStringStringMarshaller.write((BinaryOutput)byteArrayBinaryOutput, map);
                mapOfStringStringArrayMarshaller.write((BinaryOutput)byteArrayBinaryOutput, map2);
                if (stringArray != null) {
                    byteArrayBinaryOutput.writeInt(stringArray.length);
                    for (String string3 : stringArray) {
                        stringMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)string3);
                    }
                } else {
                    byteArrayBinaryOutput.writeInt(-1);
                }
                objectWithEnvironmentAccessByValueMarshaller.write((BinaryOutput)byteArrayBinaryOutput, object4);
                mapOfStringStringMarshaller.write((BinaryOutput)byteArrayBinaryOutput, map3);
                zoneIdMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)zoneId);
                long l3 = StartPoint.createContext0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), object != null ? ((NativeObject)object).getHandle() : 0L, outputStream, outputStream2, inputStream, bl, fileSystem, bl2, bl3, bl4, bl5, bl6, bl7, string, string2, processHandler, l2, object5, bl8, bl9, logHandler, object6, byteArrayBinaryOutput.getArray());
                return l3;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void ensureInstrumentCreated(Object object, String string) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                StartPoint.ensureInstrumentCreated0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), object != null ? ((NativeObject)object).getHandle() : 0L, string);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public IsolateSourceCache getSourceCache() {
            IsolateSourceCache isolateSourceCache = this.getSourceCacheCache;
            if (isolateSourceCache == null) {
                NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
                try {
                    long l2 = StartPoint.getSourceCache0(nativeIsolateThread.getIsolateThreadId(), this.getHandle());
                    this.getSourceCacheCache = isolateSourceCache = l2 != 0L ? NativeIsolateSourceCacheGen.create(this.getIsolate(), l2) : null;
                }
                catch (ForeignException foreignException) {
                    throw foreignException.throwOriginalException(throwableMarshaller);
                }
                finally {
                    nativeIsolateThread.leave();
                }
            }
            return isolateSourceCache;
        }

        @Override
        public String heapDump(String string) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                String string2 = StartPoint.heapDump0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), string);
                return string2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void initialize(PolyglotHostServices polyglotHostServices) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                StartPoint.initialize0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), polyglotHostServices);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public boolean isMemoryProtected() {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                boolean bl = StartPoint.isMemoryProtected0(nativeIsolateThread.getIsolateThreadId(), this.getHandle());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void onIsolateTearDown() {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                StartPoint.onIsolateTearDown0(nativeIsolateThread.getIsolateThreadId(), this.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public Object parseEval(Object object, String string, long l2, boolean bl) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.parseEval0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), object != null ? ((NativeObject)object).getHandle() : 0L, string, l2, bl);
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object2 = objectWithValueReceiverMarshaller.read(binaryInput);
                return object2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void triggerGC() {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                StartPoint.triggerGC0(nativeIsolateThread.getIsolateThreadId(), this.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native long buildEngine0(long var0, long var2, OutputStream var4, OutputStream var5, InputStream var6, boolean var7, boolean var8, MessageTransport var9, AbstractPolyglotImpl.LogHandler var10, Object var11, byte[] var12);

        private static native long createContext0(long var0, long var2, long var4, OutputStream var6, OutputStream var7, InputStream var8, boolean var9, FileSystem var10, boolean var11, boolean var12, boolean var13, boolean var14, boolean var15, boolean var16, String var17, String var18, ProcessHandler var19, long var20, Object var22, boolean var23, boolean var24, AbstractPolyglotImpl.LogHandler var25, Object var26, byte[] var27);

        private static native void ensureInstrumentCreated0(long var0, long var2, long var4, String var6);

        private static native long getSourceCache0(long var0, long var2);

        private static native String heapDump0(long var0, long var2, String var4) throws IOException;

        private static native void initialize0(long var0, long var2, PolyglotHostServices var4);

        private static native boolean isMemoryProtected0(long var0, long var2);

        private static native void onIsolateTearDown0(long var0, long var2);

        private static native byte[] parseEval0(long var0, long var2, long var4, String var6, long var7, boolean var9);

        private static native void triggerGC0(long var0, long var2);

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            mapOfStringStringArrayMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<Map<String, String[]>>(){}, new Class[0]);
            mapOfStringStringMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, new Class[0]);
            objectWithEnvironmentAccessByValueMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.EnvironmentAccessByValue.class});
            objectWithIOAccessByValueMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.IOAccessByValue.class});
            objectWithPolyglotAccessByValueMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.PolyglotAccessByValue.class});
            objectWithValueReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.ValueReceiver.class});
            sandboxPolicyMarshaller = jNIConfig.lookupMarshaller(SandboxPolicy.class, new Class[0]);
            stringMarshaller = jNIConfig.lookupMarshaller(String.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            zoneIdMarshaller = jNIConfig.lookupMarshaller(ZoneId.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Map<String, String[]>> mapOfStringStringArrayMarshaller;
        private static final BinaryMarshaller<Map<String, String>> mapOfStringStringMarshaller;
        private static final BinaryMarshaller<Object> objectWithEnvironmentAccessByValueMarshaller;
        private static final BinaryMarshaller<Object> objectWithIOAccessByValueMarshaller;
        private static final BinaryMarshaller<Object> objectWithPolyglotAccessByValueMarshaller;
        private static final BinaryMarshaller<Object> objectWithValueReceiverMarshaller;
        private static final BinaryMarshaller<SandboxPolicy> sandboxPolicyMarshaller;
        private static final BinaryMarshaller<String> stringMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<ZoneId> zoneIdMarshaller;

        private EndPoint() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativePolyglotIsolateServicesGen_00024StartPoint_buildEngine0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static long buildEngine(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JObject jObject, JNI.JObject jObject2, JNI.JObject jObject3, boolean bl, boolean bl2, JNI.JObject jObject4, JNI.JObject jObject5, JNI.JObject jObject6, JNI.JByteArray jByteArray) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativePolyglotIsolateServicesGen::buildEngine", jNIEnv);){
                long l4;
                block14: {
                    PolyglotIsolateServices polyglotIsolateServices = (PolyglotIsolateServices)NativeObjectHandles.resolve((long)l3, PolyglotIsolateServices.class);
                    CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)768);
                    int n2 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray);
                    CCharPointer cCharPointer2 = n2 <= 768 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc((int)n2);
                    try {
                        long l5;
                        Object object;
                        String[] stringArray;
                        JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n2, (CCharPointer)cCharPointer2);
                        BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer2, (int)n2);
                        int n3 = binaryInput.readInt();
                        if (n3 != -1) {
                            stringArray = new String[n3];
                            for (int i2 = 0; i2 < n3; ++i2) {
                                stringArray[i2] = object = (String)stringMarshaller.read(binaryInput);
                            }
                        } else {
                            stringArray = null;
                        }
                        SandboxPolicy sandboxPolicy = (SandboxPolicy)sandboxPolicyMarshaller.read(binaryInput);
                        object = (Map)mapOfStringStringMarshaller.read(binaryInput);
                        l4 = l5 = polyglotIsolateServices.buildEngine(stringArray, sandboxPolicy, jObject.isNonNull() ? HSOutputStreamGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject), jNIEnv) : null, jObject2.isNonNull() ? HSOutputStreamGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject2), jNIEnv) : null, jObject3.isNonNull() ? HSInputStreamGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject3), jNIEnv) : null, (Map<String, String>)object, bl, bl2, jObject4.isNonNull() ? HSMessageTransportGen.createNativeToHS(jNIEnv, jObject4) : null, jObject5.isNonNull() ? HSLogHandlerGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject5), jNIEnv) : null, jObject6.rawValue());
                        if (cCharPointer2 == cCharPointer) break block14;
                    }
                    catch (Throwable throwable) {
                        if (cCharPointer2 != cCharPointer) {
                            UnmanagedMemory.free((PointerBase)cCharPointer2);
                        }
                        throw throwable;
                    }
                    UnmanagedMemory.free((PointerBase)cCharPointer2);
                }
                return l4;
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                return 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativePolyglotIsolateServicesGen_00024StartPoint_createContext0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static long createContext(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, long l4, JNI.JObject jObject, JNI.JObject jObject2, JNI.JObject jObject3, boolean bl, JNI.JObject jObject4, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, JNI.JString jString, JNI.JString jString2, JNI.JObject jObject5, long l5, JNI.JObject jObject6, boolean bl8, boolean bl9, JNI.JObject jObject7, JNI.JObject jObject8, JNI.JByteArray jByteArray) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativePolyglotIsolateServicesGen::createContext", jNIEnv);){
                long l6;
                block14: {
                    PolyglotIsolateServices polyglotIsolateServices = (PolyglotIsolateServices)NativeObjectHandles.resolve((long)l3, PolyglotIsolateServices.class);
                    CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)2304);
                    int n2 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray);
                    CCharPointer cCharPointer2 = n2 <= 2304 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc((int)n2);
                    try {
                        long l7;
                        Object object;
                        String[] stringArray;
                        JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n2, (CCharPointer)cCharPointer2);
                        BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer2, (int)n2);
                        SandboxPolicy sandboxPolicy = (SandboxPolicy)sandboxPolicyMarshaller.read(binaryInput);
                        Object object2 = objectWithPolyglotAccessByValueMarshaller.read(binaryInput);
                        Object object3 = objectWithIOAccessByValueMarshaller.read(binaryInput);
                        Map map = (Map)mapOfStringStringMarshaller.read(binaryInput);
                        Map map2 = (Map)mapOfStringStringArrayMarshaller.read(binaryInput);
                        int n3 = binaryInput.readInt();
                        if (n3 != -1) {
                            stringArray = new String[n3];
                            for (int i2 = 0; i2 < n3; ++i2) {
                                stringArray[i2] = object = (String)stringMarshaller.read(binaryInput);
                            }
                        } else {
                            stringArray = null;
                        }
                        Object object4 = objectWithEnvironmentAccessByValueMarshaller.read(binaryInput);
                        object = (Map)mapOfStringStringMarshaller.read(binaryInput);
                        ZoneId zoneId = (ZoneId)zoneIdMarshaller.read(binaryInput);
                        l6 = l7 = polyglotIsolateServices.createContext(NativeObjectHandles.resolve((long)l4, Object.class), sandboxPolicy, jObject.isNonNull() ? HSOutputStreamGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject), jNIEnv) : null, jObject2.isNonNull() ? HSOutputStreamGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject2), jNIEnv) : null, jObject3.isNonNull() ? HSInputStreamGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject3), jNIEnv) : null, bl, object2, object3, jObject4.isNonNull() ? HSFileSystemGen.createNativeToHS(jNIEnv, jObject4) : null, bl2, bl3, bl4, bl5, bl6, bl7, map, map2, stringArray, JNIUtil.createString((JNI.JNIEnv)jNIEnv, (JNI.JString)jString), JNIUtil.createString((JNI.JNIEnv)jNIEnv, (JNI.JString)jString2), jObject5.isNonNull() ? HSProcessHandlerGen.createNativeToHS(jNIEnv, jObject5) : null, object4, (Map<String, String>)object, zoneId, l5, jObject6.rawValue(), bl8, bl9, jObject7.isNonNull() ? HSLogHandlerGen.createNativeToHS(new HSPolyglotObject(jNIEnv, jObject7), jNIEnv) : null, jObject8.rawValue());
                        if (cCharPointer2 == cCharPointer) break block14;
                    }
                    catch (Throwable throwable) {
                        if (cCharPointer2 != cCharPointer) {
                            UnmanagedMemory.free((PointerBase)cCharPointer2);
                        }
                        throw throwable;
                    }
                    UnmanagedMemory.free((PointerBase)cCharPointer2);
                }
                return l6;
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                return 0L;
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativePolyglotIsolateServicesGen_00024StartPoint_ensureInstrumentCreated0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void ensureInstrumentCreated(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, long l4, JNI.JString jString) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativePolyglotIsolateServicesGen::ensureInstrumentCreated", jNIEnv);){
                PolyglotIsolateServices polyglotIsolateServices = (PolyglotIsolateServices)NativeObjectHandles.resolve((long)l3, PolyglotIsolateServices.class);
                polyglotIsolateServices.ensureInstrumentCreated(NativeObjectHandles.resolve((long)l4, Object.class), JNIUtil.createString((JNI.JNIEnv)jNIEnv, (JNI.JString)jString));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativePolyglotIsolateServicesGen_00024StartPoint_getSourceCache0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static long getSourceCache(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            long l4;
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativePolyglotIsolateServicesGen::getSourceCache", jNIEnv);
            try {
                PolyglotIsolateServices polyglotIsolateServices = (PolyglotIsolateServices)NativeObjectHandles.resolve((long)l3, PolyglotIsolateServices.class);
                IsolateSourceCache isolateSourceCache = polyglotIsolateServices.getSourceCache();
                l4 = NativeObjectHandles.create((Object)isolateSourceCache);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return 0L;
                }
            }
            jNIMethodScope.close();
            return l4;
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativePolyglotIsolateServicesGen_00024StartPoint_heapDump0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString heapDump(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JString jString) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativePolyglotIsolateServicesGen::heapDump", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                PolyglotIsolateServices polyglotIsolateServices = (PolyglotIsolateServices)NativeObjectHandles.resolve((long)l3, PolyglotIsolateServices.class);
                String string = polyglotIsolateServices.heapDump(JNIUtil.createString((JNI.JNIEnv)jNIEnv, (JNI.JString)jString));
                jNIMethodScope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativePolyglotIsolateServicesGen_00024StartPoint_initialize0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void initialize(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JObject jObject) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativePolyglotIsolateServicesGen::initialize", jNIEnv);){
                PolyglotIsolateServices polyglotIsolateServices = (PolyglotIsolateServices)NativeObjectHandles.resolve((long)l3, PolyglotIsolateServices.class);
                polyglotIsolateServices.initialize(jObject.isNonNull() ? HSPolyglotHostServicesGen.createNativeToHS(jNIEnv, jObject) : null);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativePolyglotIsolateServicesGen_00024StartPoint_isMemoryProtected0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean isMemoryProtected(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            boolean bl;
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativePolyglotIsolateServicesGen::isMemoryProtected", jNIEnv);
            try {
                boolean bl2;
                PolyglotIsolateServices polyglotIsolateServices = (PolyglotIsolateServices)NativeObjectHandles.resolve((long)l3, PolyglotIsolateServices.class);
                bl = bl2 = polyglotIsolateServices.isMemoryProtected();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return false;
                }
            }
            jNIMethodScope.close();
            return bl;
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativePolyglotIsolateServicesGen_00024StartPoint_onIsolateTearDown0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void onIsolateTearDown(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativePolyglotIsolateServicesGen::onIsolateTearDown", jNIEnv);){
                PolyglotIsolateServices polyglotIsolateServices = (PolyglotIsolateServices)NativeObjectHandles.resolve((long)l3, PolyglotIsolateServices.class);
                polyglotIsolateServices.onIsolateTearDown();
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativePolyglotIsolateServicesGen_00024StartPoint_parseEval0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray parseEval(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, long l4, JNI.JString jString, long l5, boolean bl) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativePolyglotIsolateServicesGen::parseEval", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                PolyglotIsolateServices polyglotIsolateServices = (PolyglotIsolateServices)NativeObjectHandles.resolve((long)l3, PolyglotIsolateServices.class);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                Object object = polyglotIsolateServices.parseEval(NativeObjectHandles.resolve((long)l4, Object.class), JNIUtil.createString((JNI.JNIEnv)jNIEnv, (JNI.JString)jString), l5, bl);
                int n2 = objectWithValueReceiverMarshaller.inferSize(object);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create((int)n2) : BinaryOutput.create((CCharPointer)cCharPointer, (int)256, (boolean)false);){
                    objectWithValueReceiverMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n3);
                    JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n3, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult((JNI.JObject)jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativePolyglotIsolateServicesGen_00024StartPoint_triggerGC0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void triggerGC(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativePolyglotIsolateServicesGen::triggerGC", jNIEnv);){
                PolyglotIsolateServices polyglotIsolateServices = (PolyglotIsolateServices)NativeObjectHandles.resolve((long)l3, PolyglotIsolateServices.class);
                polyglotIsolateServices.triggerGC();
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            mapOfStringStringArrayMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<Map<String, String[]>>(){}, new Class[0]);
            mapOfStringStringMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<Map<String, String>>(){}, new Class[0]);
            objectWithEnvironmentAccessByValueMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.EnvironmentAccessByValue.class});
            objectWithIOAccessByValueMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.IOAccessByValue.class});
            objectWithPolyglotAccessByValueMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.PolyglotAccessByValue.class});
            objectWithValueReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.ValueReceiver.class});
            sandboxPolicyMarshaller = jNIConfig.lookupMarshaller(SandboxPolicy.class, new Class[0]);
            stringMarshaller = jNIConfig.lookupMarshaller(String.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            zoneIdMarshaller = jNIConfig.lookupMarshaller(ZoneId.class, new Class[0]);
        }
    }
}

