module com.oracle.truffle.enterprise {
    requires java.logging;
    /* static phase */ requires jdk.internal.vm.ci;
    requires jdk.management;
    requires jdk.unsupported;
    requires org.graalvm.collections;
    requires org.graalvm.jniutils;
    requires org.graalvm.nativebridge;
    requires org.graalvm.nativeimage;
    requires org.graalvm.polyglot;
    requires org.graalvm.truffle;
    requires org.graalvm.truffle.compiler;
    requires org.graalvm.truffle.runtime;
    /* transitive */ requires org.graalvm.word;

    exports com.oracle.truffle.object.enterprise to com.oracle.truffle.enterprise.svm;
    exports com.oracle.truffle.polyglot.enterprise to com.oracle.truffle.enterprise.svm;
    exports com.oracle.truffle.runtime.enterprise to com.oracle.truffle.enterprise.svm;
    exports com.oracle.truffle.sandbox.enterprise to com.oracle.truffle.enterprise.svm;

    provides TruffleInstrumentProvider with i;
    provides LayoutFactory with d;
    provides EngineCacheSupport with DebugEngineCacheSupport;
    provides TruffleTypes with EnterpriseTruffleTypes;
    provides AbstractPolyglotImpl with EnterprisePolyglotImpl;

}

