/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.impl.asm.ClassWriter;
import com.oracle.truffle.api.impl.asm.MethodVisitor;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import jdk.internal.module.Modules;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class ModulesAccessor {
    ModulesAccessor() {
    }

    abstract void addExports(Module var1, String var2, Module var3);

    abstract void addExportsToAllUnnamed(Module var1, String var2);

    abstract void addOpens(Module var1, String var2, Module var3);

    abstract void addOpensToAllUnnamed(Module var1, String var2);

    abstract Module getTargetModule();

    static ModulesAccessor create(Class<?> accessingClass) {
        if (accessingClass.getModule().isNamed()) {
            return new DirectImpl(accessingClass);
        }
        try {
            return new IsolatedImpl(accessingClass);
        }
        catch (ReflectiveOperationException e) {
            throw new InternalError(e);
        }
    }

    static final class DirectImpl
    extends ModulesAccessor {
        private final Class<?> baseClass;

        DirectImpl(Class<?> baseClass) {
            if (!baseClass.getModule().isNamed()) {
                throw new IllegalStateException("");
            }
            this.baseClass = baseClass;
        }

        @Override
        void addExports(Module base, String p, Module target) {
            Modules.addExports(base, p, target);
        }

        @Override
        void addExportsToAllUnnamed(Module base, String p) {
            Modules.addExportsToAllUnnamed(base, p);
        }

        @Override
        void addOpens(Module base, String p, Module target) {
            Modules.addOpens(base, p, target);
        }

        @Override
        void addOpensToAllUnnamed(Module base, String p) {
            Modules.addOpensToAllUnnamed(base, p);
        }

        @Override
        Module getTargetModule() {
            return this.baseClass.getModule();
        }
    }

    static final class IsolatedImpl
    extends ModulesAccessor {
        private final MethodHandle addExports;
        private final MethodHandle addExportsToAllUnnamed;
        private final MethodHandle addOpens;
        private final MethodHandle addOpensToAllUnnamed;
        private final Module targetModule;

        IsolatedImpl(Class<?> baseClass) throws ReflectiveOperationException {
            String moduleName = "org.graalvm.truffle.runtime.generated";
            String targetPackage = baseClass.getPackageName() + ".generated";
            String className = targetPackage + ".GeneratedModules";
            final String binaryClassName = className.replace('.', '/');
            ClassWriter cw = new ClassWriter(0);
            cw.visit(52, 33, binaryClassName, null, "java/lang/Object", null);
            MethodVisitor constructor = cw.visitMethod(1, "<init>", "()V", null, null);
            constructor.visitCode();
            constructor.visitVarInsn(25, 0);
            constructor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            constructor.visitInsn(177);
            constructor.visitMaxs(1, 1);
            constructor.visitEnd();
            MethodVisitor mv1 = cw.visitMethod(9, "addExports", "(Ljava/lang/Module;Ljava/lang/String;Ljava/lang/Module;)V", null, null);
            mv1.visitCode();
            mv1.visitVarInsn(25, 0);
            mv1.visitVarInsn(25, 1);
            mv1.visitVarInsn(25, 2);
            mv1.visitMethodInsn(184, "jdk/internal/module/Modules", "addExports", "(Ljava/lang/Module;Ljava/lang/String;Ljava/lang/Module;)V", false);
            mv1.visitInsn(177);
            mv1.visitMaxs(3, 3);
            mv1.visitEnd();
            MethodVisitor mv2 = cw.visitMethod(9, "addExportsToAllUnnamed", "(Ljava/lang/Module;Ljava/lang/String;)V", null, null);
            mv2.visitCode();
            mv2.visitVarInsn(25, 0);
            mv2.visitVarInsn(25, 1);
            mv2.visitMethodInsn(184, "jdk/internal/module/Modules", "addExportsToAllUnnamed", "(Ljava/lang/Module;Ljava/lang/String;)V", false);
            mv2.visitInsn(177);
            mv2.visitMaxs(2, 2);
            mv2.visitEnd();
            MethodVisitor mv3 = cw.visitMethod(9, "addOpens", "(Ljava/lang/Module;Ljava/lang/String;Ljava/lang/Module;)V", null, null);
            mv3.visitCode();
            mv3.visitVarInsn(25, 0);
            mv3.visitVarInsn(25, 1);
            mv3.visitVarInsn(25, 2);
            mv3.visitMethodInsn(184, "jdk/internal/module/Modules", "addOpens", "(Ljava/lang/Module;Ljava/lang/String;Ljava/lang/Module;)V", false);
            mv3.visitInsn(177);
            mv3.visitMaxs(3, 3);
            mv3.visitEnd();
            MethodVisitor mv4 = cw.visitMethod(9, "addOpensToAllUnnamed", "(Ljava/lang/Module;Ljava/lang/String;)V", null, null);
            mv4.visitCode();
            mv4.visitVarInsn(25, 0);
            mv4.visitVarInsn(25, 1);
            mv4.visitMethodInsn(184, "jdk/internal/module/Modules", "addOpensToAllUnnamed", "(Ljava/lang/Module;Ljava/lang/String;)V", false);
            mv4.visitInsn(177);
            mv4.visitMaxs(2, 2);
            mv4.visitEnd();
            cw.visitEnd();
            final byte[] classBytes = cw.toByteArray();
            final ModuleDescriptor descriptor = ModuleDescriptor.newModule("org.graalvm.truffle.runtime.generated").exports(targetPackage).build();
            ModuleFinder finder = new ModuleFinder(){
                final /* synthetic */ IsolatedImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Optional<ModuleReference> find(String name) {
                    if (name.equals("org.graalvm.truffle.runtime.generated")) {
                        return Optional.of(new ModuleReference(descriptor, null){

                            @Override
                            public ModuleReader open() throws IOException {
                                return new ModuleReader(){

                                    @Override
                                    public Optional<ByteBuffer> read(String name) throws IOException {
                                        if (name.equals(binaryClassName + ".class")) {
                                            return Optional.of(ByteBuffer.wrap(classBytes));
                                        }
                                        return Optional.empty();
                                    }

                                    @Override
                                    public void close() throws IOException {
                                    }

                                    @Override
                                    public Optional<URI> find(String name) throws IOException {
                                        return Optional.empty();
                                    }

                                    @Override
                                    public Stream<String> list() throws IOException {
                                        return Stream.empty();
                                    }
                                };
                            }
                        });
                    }
                    return Optional.empty();
                }

                @Override
                public Set<ModuleReference> findAll() {
                    return Collections.singleton(this.find("org.graalvm.truffle.runtime.generated").get());
                }
            };
            ModuleLayer bootLayer = ModuleLayer.boot();
            Configuration cf = bootLayer.configuration().resolve(finder, ModuleFinder.of(new Path[0]), Collections.singleton("org.graalvm.truffle.runtime.generated"));
            ModuleLayer layer = bootLayer.defineModulesWithOneLoader(cf, ClassLoader.getSystemClassLoader());
            Class<?> generatedClass = layer.findLoader("org.graalvm.truffle.runtime.generated").loadClass(className);
            this.targetModule = generatedClass.getModule();
            MethodHandles.Lookup l = MethodHandles.lookup();
            l.accessClass(generatedClass);
            this.addExports = l.findStatic(generatedClass, "addExports", MethodType.methodType(Void.TYPE, Module.class, String.class, Module.class));
            this.addExportsToAllUnnamed = l.findStatic(generatedClass, "addExportsToAllUnnamed", MethodType.methodType(Void.TYPE, Module.class, String.class));
            this.addOpens = l.findStatic(generatedClass, "addOpens", MethodType.methodType(Void.TYPE, Module.class, String.class, Module.class));
            this.addOpensToAllUnnamed = l.findStatic(generatedClass, "addOpensToAllUnnamed", MethodType.methodType(Void.TYPE, Module.class, String.class));
        }

        @Override
        Module getTargetModule() {
            return this.targetModule;
        }

        @Override
        public void addExports(Module base, String p, Module target) {
            try {
                this.addExports.invokeExact(base, p, target);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }

        @Override
        public void addExportsToAllUnnamed(Module base, String p) {
            try {
                this.addExportsToAllUnnamed.invokeExact(base, p);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }

        @Override
        void addOpens(Module base, String p, Module target) {
            try {
                this.addOpens.invokeExact(base, p, target);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }

        @Override
        void addOpensToAllUnnamed(Module base, String p) {
            try {
                this.addOpensToAllUnnamed.invokeExact(base, p);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }
    }
}

