/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.internal.bytebuddy.ByteBuddyState;
import org.hibernate.bytecode.internal.bytebuddy.PassThroughInterceptor;
import org.hibernate.bytecode.spi.BasicProxyFactory;
import org.hibernate.cfg.Environment;
import org.hibernate.proxy.ProxyConfiguration;

public class BasicProxyFactoryImpl
implements BasicProxyFactory {
    private static final Class[] NO_INTERFACES = new Class[0];
    private static final NamingStrategy PROXY_NAMING = Environment.useLegacyProxyClassnames() ? new NamingStrategy.SuffixingRandom("HibernateBasicProxy$") : new NamingStrategy.SuffixingRandom("HibernateBasicProxy");
    private final Class proxyClass;

    public BasicProxyFactoryImpl(Class superClass, Class[] interfaces, ByteBuddyState bytebuddy) {
        if (superClass == null && (interfaces == null || interfaces.length < 1)) {
            throw new AssertionFailure("attempting to build proxy without any superclass or interfaces");
        }
        HashSet<Class> key = new HashSet<Class>();
        if (superClass != null) {
            key.add(superClass);
        }
        if (interfaces != null && interfaces.length > 0) {
            key.addAll(Arrays.asList(interfaces));
        }
        this.proxyClass = bytebuddy.getCurrentyByteBuddy().with(PROXY_NAMING).subclass(superClass == null ? Object.class : superClass).implement((Type[])(interfaces == null ? NO_INTERFACES : interfaces)).defineField("$$_hibernate_interceptor", ProxyConfiguration.Interceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).method((ElementMatcher)ElementMatchers.isVirtual().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isFinalizer()))).intercept((Implementation)MethodDelegation.toField((String)"$$_hibernate_interceptor")).implement(new Type[]{ProxyConfiguration.class}).intercept((Implementation)FieldAccessor.ofField((String)"$$_hibernate_interceptor").withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).make().load(BasicProxyFactory.class.getClassLoader()).getLoaded();
    }

    @Override
    public Object getProxy() {
        try {
            ProxyConfiguration proxy = (ProxyConfiguration)this.proxyClass.newInstance();
            proxy.$$_hibernate_set_interceptor(new PassThroughInterceptor(proxy, this.proxyClass.getName()));
            return proxy;
        }
        catch (Throwable t) {
            throw new HibernateException("Unable to instantiate proxy instance");
        }
    }

    public boolean isInstance(Object object) {
        return this.proxyClass.isInstance(object);
    }
}

