/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.logger;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.hibernate.testing.logger.LogListener;
import org.jboss.logging.Logger;

public final class Log4DelegatingLogger
extends org.jboss.logging.Logger {
    private final Logger logger;
    private final List<LogListener> enabledListeners = new LinkedList<LogListener>();
    private final AtomicBoolean interceptEnabled = new AtomicBoolean(false);

    Log4DelegatingLogger(String name) {
        super(name);
        this.logger = Logger.getLogger((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerListener(LogListener newListener) {
        List<LogListener> list = this.enabledListeners;
        synchronized (list) {
            if (newListener != null) {
                this.enabledListeners.add(newListener);
                this.interceptEnabled.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAllListeners() {
        List<LogListener> list = this.enabledListeners;
        synchronized (list) {
            this.enabledListeners.clear();
            this.interceptEnabled.set(false);
        }
    }

    public boolean isEnabled(Logger.Level level) {
        Level l = Log4DelegatingLogger.translate(level);
        return this.logger.isEnabledFor((Priority)l) && l.isGreaterOrEqual((Priority)this.logger.getEffectiveLevel());
    }

    protected void doLog(Logger.Level level, String loggerClassName, Object message, Object[] parameters, Throwable thrown) {
        Level translatedLevel = Log4DelegatingLogger.translate(level);
        if (this.interceptEnabled.get()) {
            this.intercept(level, parameters == null || parameters.length == 0 ? String.valueOf(message) : MessageFormat.format(String.valueOf(message), parameters), thrown);
        }
        if (!this.logger.isEnabledFor((Priority)translatedLevel)) {
            return;
        }
        try {
            this.logger.log(loggerClassName, (Priority)translatedLevel, (Object)(parameters == null || parameters.length == 0 ? String.valueOf(message) : MessageFormat.format(String.valueOf(message), parameters)), thrown);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intercept(Logger.Level level, String renderedMessage, Throwable thrown) {
        List<LogListener> list = this.enabledListeners;
        synchronized (list) {
            for (LogListener listener : this.enabledListeners) {
                listener.loggedEvent(level, renderedMessage, thrown);
            }
        }
    }

    protected void doLogf(Logger.Level level, String loggerClassName, String format, Object[] parameters, Throwable thrown) {
        Level translatedLevel = Log4DelegatingLogger.translate(level);
        if (this.interceptEnabled.get()) {
            this.intercept(level, parameters == null ? format : String.format(format, parameters), thrown);
        }
        if (!this.logger.isEnabledFor((Priority)translatedLevel)) {
            return;
        }
        try {
            this.logger.log(loggerClassName, (Priority)translatedLevel, (Object)(parameters == null ? format : String.format(format, parameters)), thrown);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Level translate(Logger.Level level) {
        if (level == null) {
            return Level.ALL;
        }
        switch (level) {
            case FATAL: {
                return Level.FATAL;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case WARN: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        return Level.ALL;
    }
}

