/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.Map;
import org.hibernate.LockOptions;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.SybaseAnywhereSqlAstTranslator;
import org.hibernate.community.dialect.identity.SybaseAnywhereIdentityColumnSupport;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SybaseAnywhereDialect
extends SybaseDialect {
    public SybaseAnywhereDialect() {
        this(DatabaseVersion.make((Integer)8));
    }

    public SybaseAnywhereDialect(DialectResolutionInfo info) {
        super(info);
    }

    public SybaseAnywhereDialect(DatabaseVersion version) {
        super(version);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case 2013: 
            case 2014: {
                return "timestamp with time zone";
            }
            case 4001: {
                return "long varchar";
            }
            case 4002: {
                return "long nvarchar";
            }
            case 4003: {
                return "long binary";
            }
            case 2011: {
                return "ntext";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    public boolean useMaterializedLobWhenCapacityExceeded() {
        return false;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.listagg_list("varchar");
        if (this.getVersion().isSameOrAfter(12)) {
            functionFactory.windowFunctions();
        }
    }

    public int getMaxVarcharLength() {
        return Short.MAX_VALUE;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SybaseAnywhereSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NATIVE;
    }

    public String currentDate() {
        return "current date";
    }

    public String currentTime() {
        return "current time";
    }

    public String currentTimestamp() {
        return "current timestamp";
    }

    public String getNoColumnsInsertString() {
        return "values (default)";
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(12);
    }

    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(10);
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return SybaseAnywhereIdentityColumnSupport.INSTANCE;
    }

    public RowLockStrategy getWriteRowLockStrategy() {
        return this.getVersion().isSameOrAfter(10) ? RowLockStrategy.COLUMN : RowLockStrategy.TABLE;
    }

    public String getForUpdateString() {
        return this.getVersion().isBefore(10) ? "" : " for update";
    }

    public String getForUpdateString(String aliases) {
        return this.getVersion().isBefore(10) ? "" : this.getForUpdateString() + " of " + aliases;
    }

    public String appendLockHint(LockOptions mode, String tableName) {
        return this.getVersion().isBefore(10) ? super.appendLockHint(mode, tableName) : tableName;
    }

    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return this.getVersion().isBefore(10) ? super.applyLocksToSql(sql, aliasedLockOptions, keyColumnNames) : sql + new ForUpdateFragment((Dialect)this, aliasedLockOptions, keyColumnNames).toFragmentString();
    }

    public LimitHandler getLimitHandler() {
        return TopLimitHandler.INSTANCE;
    }
}

