/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.ClientContext;
import hprose.client.CookieManager;
import hprose.client.HproseClient;
import hprose.common.HproseException;
import hprose.common.InvokeSettings;
import hprose.io.ByteBufferStream;
import hprose.io.HproseMode;
import hprose.util.Base64;
import hprose.util.concurrent.Promise;
import hprose.util.concurrent.Threads;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HproseHttpClient
extends HproseClient {
    private static volatile ExecutorService pool = Executors.newCachedThreadPool();
    private final ConcurrentHashMap<String, String> headers = new ConcurrentHashMap();
    private static boolean disableGlobalCookie;
    private static CookieManager globalCookieManager;
    private final CookieManager cookieManager = disableGlobalCookie ? new CookieManager() : globalCookieManager;
    private boolean keepAlive = true;
    private int keepAliveTimeout = 300;
    private String proxyHost = null;
    private int proxyPort = 80;
    private String proxyUser = null;
    private String proxyPass = null;
    private HostnameVerifier hv = null;
    private SSLSocketFactory sslsf = null;

    public static void setThreadPool(ExecutorService threadPool) {
        pool = threadPool;
    }

    public static void setDisableGlobalCookie(boolean value) {
        disableGlobalCookie = value;
    }

    public static boolean isDisableGlobalCookie() {
        return disableGlobalCookie;
    }

    public HproseHttpClient() {
    }

    public HproseHttpClient(String uri) {
        super(uri);
    }

    public HproseHttpClient(HproseMode mode) {
        super(mode);
    }

    public HproseHttpClient(String uri, HproseMode mode) {
        super(uri, mode);
    }

    public HproseHttpClient(String[] uris) {
        super(uris);
    }

    public HproseHttpClient(String[] uris, HproseMode mode) {
        super(uris, mode);
    }

    public static HproseClient create(String uri, HproseMode mode) throws IOException, URISyntaxException {
        String scheme = new URI(uri).getScheme();
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            throw new HproseException("This client doesn't support " + scheme + " scheme.");
        }
        return new HproseHttpClient(uri, mode);
    }

    public static HproseClient create(String[] uris, HproseMode mode) throws IOException, URISyntaxException {
        int n = uris.length;
        for (int i = 0; i < n; ++i) {
            String scheme = new URI(uris[i]).getScheme();
            if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) continue;
            throw new HproseException("This client doesn't support " + scheme + " scheme.");
        }
        return new HproseHttpClient(uris, mode);
    }

    public void setHeader(String name, String value) {
        String nl = name.toLowerCase();
        if (!(nl.equals("content-type") || nl.equals("content-length") || nl.equals("connection") || nl.equals("keep-alive") || nl.equals("host"))) {
            if (value == null) {
                this.headers.remove(name);
            } else {
                this.headers.put(name, value);
            }
        }
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public void setProxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hv;
    }

    public void setHostnameVerifier(HostnameVerifier hv) {
        this.hv = hv;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslsf;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslsf) {
        this.sslsf = sslsf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteBuffer syncSendAndReceive(ByteBuffer request, ClientContext context) throws Throwable {
        String key;
        HttpURLConnection conn;
        URL url;
        block28: {
            OutputStream outputStream;
            InvokeSettings settings = context.getSettings();
            int timeout = settings.getTimeout();
            url = new URL(this.uri);
            Properties prop = System.getProperties();
            prop.put("http.keepAlive", Boolean.toString(this.keepAlive));
            if (this.proxyHost != null) {
                prop.put("http.proxyHost", this.proxyHost);
                prop.put("http.proxyPort", Integer.toString(this.proxyPort));
            } else {
                prop.remove("http.proxyHost");
                prop.remove("http.proxyPort");
            }
            conn = (HttpURLConnection)url.openConnection();
            if (url.getProtocol().equals("https")) {
                if (this.hv != null) {
                    ((HttpsURLConnection)conn).setHostnameVerifier(this.hv);
                }
                if (this.sslsf != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslsf);
                }
            }
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
            conn.setRequestProperty("Cookie", this.cookieManager.getCookie(url.getHost(), url.getFile(), url.getProtocol().equals("https")));
            if (this.keepAlive) {
                conn.setRequestProperty("Connection", "keep-alive");
                conn.setRequestProperty("Keep-Alive", Integer.toString(this.keepAliveTimeout));
            } else {
                conn.setRequestProperty("Connection", "close");
            }
            if (this.proxyUser != null && this.proxyPass != null) {
                conn.setRequestProperty("Proxy-Authorization", "Basic " + Base64.encode((this.proxyUser + ":" + this.proxyPass).getBytes()));
            }
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
            Map header = (Map)context.get("httpHeader");
            if (header != null) {
                for (Map.Entry entry : header.entrySet()) {
                    String key2 = (String)entry.getKey();
                    for (String value : (List)entry.getValue()) {
                        conn.addRequestProperty(key2, value);
                    }
                }
            }
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Content-Type", "application/hprose");
            conn.setRequestProperty("Content-Length", Integer.toString(request.remaining()));
            OutputStream outputStream2 = null;
            try {
                outputStream = conn.getOutputStream();
                ByteBufferStream byteBufferStream = new ByteBufferStream(request);
                byteBufferStream.writeTo(outputStream);
                outputStream.flush();
                if (outputStream == null) break block28;
            }
            catch (Throwable throwable) {
                if (outputStream2 == null) throw throwable;
                outputStream2.close();
                throw throwable;
            }
            outputStream.close();
        }
        context.set("httpHeader", conn.getHeaderFields());
        ArrayList<String> arrayList = new ArrayList<String>();
        int i = 1;
        while ((key = conn.getHeaderFieldKey(i)) != null) {
            if (key.equalsIgnoreCase("set-cookie") || key.equalsIgnoreCase("set-cookie2")) {
                arrayList.add(conn.getHeaderField(i));
            }
            ++i;
        }
        this.cookieManager.setCookie(arrayList, url.getHost());
        ByteBufferStream response = new ByteBufferStream();
        try (InputStream istream = null;){
            istream = conn.getInputStream();
            response.readFrom(istream);
            response.flip();
            ByteBuffer byteBuffer = response.buffer;
            return byteBuffer;
        }
    }

    @Override
    protected Promise<ByteBuffer> sendAndReceive(final ByteBuffer request, final ClientContext context) {
        final Promise<ByteBuffer> promise = new Promise<ByteBuffer>();
        pool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    promise.resolve(HproseHttpClient.this.syncSendAndReceive(request, context));
                }
                catch (Throwable ex) {
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    static {
        Threads.registerShutdownHandler(new Runnable(){

            @Override
            public void run() {
                ExecutorService p = pool;
                pool = Executors.newCachedThreadPool();
                p.shutdownNow();
            }
        });
        disableGlobalCookie = false;
        globalCookieManager = new CookieManager();
    }
}

