/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.BaseUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.ReferenceReader;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public final class BigDecimalUnserializer
extends BaseUnserializer<BigDecimal> {
    public static final BigDecimalUnserializer instance = new BigDecimalUnserializer();

    @Override
    public BigDecimal unserialize(Reader reader, int tag, Type type) throws IOException {
        if (tag >= 48 && tag <= 57) {
            return BigDecimal.valueOf(tag - 48);
        }
        switch (tag) {
            case 100: 
            case 105: 
            case 108: {
                return new BigDecimal(ValueReader.readUntil(reader, 59).toString());
            }
            case 101: {
                return BigDecimal.ZERO;
            }
            case 116: {
                return BigDecimal.ONE;
            }
            case 102: {
                return BigDecimal.ZERO;
            }
            case 117: {
                return new BigDecimal(ValueReader.readUTF8Char(reader));
            }
            case 115: {
                return new BigDecimal(ReferenceReader.readString(reader));
            }
        }
        return (BigDecimal)super.unserialize(reader, tag, type);
    }

    public BigDecimal read(Reader reader) throws IOException {
        return (BigDecimal)this.read(reader, (Type)((Object)BigDecimal.class));
    }
}

