/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import java.util.Collection;
import javax.validation.ValidationException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.exception.DuplicateKeyException;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.exception.NotFoundException;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.system.authorization.api.PasswordEncoder;
import org.hswebframework.web.system.authorization.api.PasswordValidator;
import org.hswebframework.web.system.authorization.api.UsernameValidator;
import org.hswebframework.web.system.authorization.api.entity.UserEntity;
import org.hswebframework.web.system.authorization.api.event.UserCreatedEvent;
import org.hswebframework.web.system.authorization.api.event.UserDeletedEvent;
import org.hswebframework.web.system.authorization.api.event.UserModifiedEvent;
import org.hswebframework.web.system.authorization.api.service.reactive.ReactiveUserService;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveUserService
extends GenericReactiveCrudService<UserEntity, String>
implements ReactiveUserService {
    @Autowired
    private ReactiveRepository<UserEntity, String> repository;
    @Autowired(required=false)
    private PasswordEncoder passwordEncoder = (password, salt) -> DigestUtils.md5Hex((String)String.format("hsweb.%s.framework.%s", password, salt));
    @Autowired(required=false)
    private PasswordValidator passwordValidator = password -> {};
    @Autowired(required=false)
    private UsernameValidator usernameValidator = username -> {};
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public Mono<UserEntity> newUserInstance() {
        return this.getRepository().newInstance();
    }

    @Transactional(rollbackFor={Exception.class}, transactionManager="connectionFactoryTransactionManager")
    public Mono<Boolean> saveUser(Mono<UserEntity> request) {
        return request.flatMap(userEntity -> {
            if (StringUtils.isEmpty((Object)userEntity.getId())) {
                return this.doAdd((UserEntity)userEntity);
            }
            return this.findById(userEntity.getId()).flatMap(ignore -> this.doUpdate((UserEntity)userEntity)).switchIfEmpty(Mono.error(NotFoundException::new));
        }).thenReturn((Object)true);
    }

    protected Mono<UserEntity> doAdd(UserEntity userEntity) {
        return Mono.defer(() -> {
            this.usernameValidator.validate(userEntity.getUsername());
            this.passwordValidator.validate(userEntity.getPassword());
            userEntity.generateId();
            userEntity.setSalt((String)IDGenerator.RANDOM.generate());
            userEntity.setPassword(this.passwordEncoder.encode(userEntity.getPassword(), userEntity.getSalt()));
            return ((Mono)((ReactiveQuery)this.createQuery().where(() -> ((UserEntity)userEntity).getUsername())).fetch().doOnNext(u -> {
                throw new org.hswebframework.web.exception.ValidationException("error.user_already_exists");
            }).then(Mono.just((Object)userEntity)).as(arg_0 -> ((ReactiveRepository)this.getRepository()).insert(arg_0))).onErrorMap(DuplicateKeyException.class, e -> {
                throw new org.hswebframework.web.exception.ValidationException("error.user_already_exists");
            }).thenReturn((Object)userEntity).flatMap(user -> new UserCreatedEvent(user).publish(this.eventPublisher)).thenReturn((Object)userEntity);
        });
    }

    protected Mono<UserEntity> doUpdate(UserEntity userEntity) {
        return Mono.defer(() -> {
            boolean passwordChanged = StringUtils.hasText((String)userEntity.getPassword());
            if (passwordChanged) {
                userEntity.setSalt((String)IDGenerator.RANDOM.generate());
                this.passwordValidator.validate(userEntity.getPassword());
                userEntity.setPassword(this.passwordEncoder.encode(userEntity.getPassword(), userEntity.getSalt()));
            }
            return ((ReactiveUpdate)((ReactiveUpdate)this.getRepository().createUpdate().set((Object)userEntity)).where(() -> ((UserEntity)userEntity).getId())).execute().flatMap(__ -> new UserModifiedEvent(userEntity, passwordChanged).publish(this.eventPublisher)).thenReturn((Object)userEntity);
        });
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    public Mono<UserEntity> findById(String id) {
        return this.getRepository().findById(Mono.just((Object)id));
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    public Mono<UserEntity> findByUsername(String username) {
        return Mono.justOrEmpty((Object)username).flatMap(_name -> ((ReactiveQuery)this.repository.createQuery().where(UserEntity::getUsername, _name)).fetchOne());
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    public Mono<UserEntity> findByUsernameAndPassword(String username, String plainPassword) {
        return Mono.justOrEmpty((Object)username).flatMap(_name -> ((ReactiveQuery)this.repository.createQuery().where(UserEntity::getUsername, _name)).fetchOne()).filter(user -> this.passwordEncoder.encode(plainPassword, user.getSalt()).equals(user.getPassword()));
    }

    @Transactional(rollbackFor={Exception.class}, transactionManager="connectionFactoryTransactionManager")
    public Mono<Integer> changeState(Publisher<String> userId, byte state) {
        return Flux.from(userId).collectList().filter(CollectionUtils::isNotEmpty).flatMap(list -> ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.repository.createUpdate().set(UserEntity::getStatus, (Object)state)).where()).in(UserEntity::getId, (Collection)list)).execute()).defaultIfEmpty((Object)0);
    }

    @Transactional(rollbackFor={Exception.class}, transactionManager="connectionFactoryTransactionManager")
    public Mono<Boolean> changePassword(String userId, String oldPassword, String newPassword) {
        this.passwordValidator.validate(newPassword);
        return this.findById(userId).switchIfEmpty(Mono.error(NotFoundException::new)).filter(user -> this.passwordEncoder.encode(oldPassword, user.getSalt()).equals(user.getPassword())).switchIfEmpty(Mono.error(() -> new ValidationException("\u5bc6\u7801\u9519\u8bef"))).flatMap(user -> ((ReactiveUpdate)((ReactiveUpdate)this.repository.createUpdate().set(UserEntity::getPassword, (Object)this.passwordEncoder.encode(newPassword, user.getSalt()))).where(() -> ((UserEntity)user).getId())).execute()).map(i -> i > 0);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    public Flux<UserEntity> findUser(QueryParam queryParam) {
        return ((ReactiveQuery)this.repository.createQuery().setParam(queryParam)).fetch();
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    public Mono<Integer> countUser(QueryParam queryParam) {
        return ((ReactiveQuery)this.repository.createQuery().setParam(queryParam)).count();
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    public Mono<Boolean> deleteUser(String userId) {
        return this.findById(userId).flatMap(user -> this.deleteById((Publisher)Mono.just((Object)userId)).flatMap(i -> new UserDeletedEvent(user).publish(this.eventPublisher)).thenReturn((Object)true));
    }
}

