/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public interface NullabilityDetector {
    public NullabilityAccessor getParameterNullability(Method var1);

    public NullabilityAccessor getParameterNullability(Constructor<?> var1);

    public static interface NullabilityAccessor {
        public static final NullabilityAccessor TRUE = ignored -> true;
        public static final NullabilityAccessor FALSE = ignored -> false;
        public static final NullabilityAccessor INDEX_OUT_OF_BOUNDS = i -> {
            throw new IndexOutOfBoundsException(String.format("Index %s out of bounds [0,0)", i));
        };

        public boolean isNullable(int var1);

        public static NullabilityAccessor compress(boolean[] values) {
            int length = values.length;
            if (length == 0) {
                return INDEX_OUT_OF_BOUNDS;
            }
            if (length == 1) {
                return values[0] ? TRUE : FALSE;
            }
            Boolean allMatch = values[0];
            for (boolean value : values) {
                if (allMatch == value) continue;
                allMatch = null;
                break;
            }
            if (allMatch != null) {
                return allMatch != false ? TRUE : FALSE;
            }
            if (length < 32) {
                int compressed = 0;
                for (int i2 = 0; i2 < length; ++i2) {
                    if (!values[i2]) continue;
                    compressed |= 1 << i2;
                }
                int compressedFinal = compressed;
                return i -> (compressedFinal >> i & 1) != 0;
            }
            return i -> values[i];
        }
    }
}

