/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.xerces.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class DOMMessageFormatter {
    private static final ResourceBundle DOM_RESOURCE_BUNDLE = ResourceBundle.getBundle("org.htmlunit.cyberneko.res.DOMMessages");

    private DOMMessageFormatter() {
    }

    public static String formatMessage(String key, Object[] arguments) throws MissingResourceException {
        try {
            String msg = key + ": " + DOM_RESOURCE_BUNDLE.getString(key);
            if (arguments != null) {
                try {
                    msg = MessageFormat.format(msg, arguments);
                }
                catch (Exception e) {
                    msg = DOM_RESOURCE_BUNDLE.getString("FormatFailed");
                    msg = msg + " " + DOM_RESOURCE_BUNDLE.getString(key);
                }
            }
            return msg;
        }
        catch (MissingResourceException e) {
            MissingResourceException mre = new MissingResourceException(key, DOM_RESOURCE_BUNDLE.getString("BadMessageKey"), key);
            mre.initCause(e);
            throw mre;
        }
    }
}

